<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.8.18 2023-06-04
 *
 * @package     iCagenda.Site
 * @subpackage  tmpl.events
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2024 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.8
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
?>

<div id="icagenda" class="ic-list-view<?php echo $this->pageclass_sfx; ?>">
	<?php if ($this->params->get('show_page_heading', 1)) : ?>
	<div class="page-header">
		<h1> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
	</div>
	<?php endif; ?>

	<?php // Content is generated by content plugin event "iCagendaOnListBeforeDisplay" ?>
	<?php echo $this->event->iCagendaOnListBeforeDisplay; ?>

	<?php // Start List of events ?>
	<form id="icagenda-list"
		name="iclist"
		action="<?php echo Route::_('index.php?option=com_icagenda&view=events&Itemid=' . Factory::getApplication()->input->get('Itemid', 0)); ?>"
		method="get">

		<?php // Menu Item Link : not needed with form get method when SEF enabled, as processed by the router ?>
		<?php if (Factory::getApplication()->getCfg('sef') != 1) : ?>
			<input name="option" type="hidden" value="com_icagenda" />
			<input name="view" type="hidden" value="events" />
			<input name="Itemid" type="hidden" value="<?php echo Factory::getApplication()->input->get('Itemid', 0); ?>" />
		<?php endif; ?>

		<?php // Search Filters ?>
		<?php if ($this->params->get('search_filters', '0')) : ?>
			<?php echo $this->loadTemplate('filters'); ?>
		<?php endif; ?>

		<?php // Start Header ?>
		<div class="ic-clearfix">

			<?php // Header - Title / Subtitle ?>
			<?php echo $this->header; ?>

			<?php // Header - Categories Information ?>
			<?php echo $this->loadTemplate('categories'); ?>

		</div>
		<?php // End Header ?>

		<?php // Header - Pagination ?>
		<?php if ( in_array($this->params->get('navposition', 1), array('0', '2')) ) : ?>
			<div class="ic-clearfix">
				<?php echo $this->pagination; ?>
			</div>
		<?php endif; ?>

		<?php // List of events ?>
		<div class="ic-list-events ic-clearfix">
			<?php echo '<!-- ' . $this->template . ' -->'; ?>

			<?php foreach ($this->items as $k => $item) : ?>

				<?php // Get the date ?>
				<?php $evt = $this->evt[$k]; ?>

				<?php // Load preset data variables for list of events ?>
				<?php require $this->listShortcuts; ?>

				<?php // Check if cancelled, to add ic-event-cancelled class if true ?>
				<?php $isCancelled = $item->params->get('event_cancelled', 0) ? ' ic-event-cancelled' : ''; ?>

				<div class="ic-list-event ic-clearfix ic-event-id-<?php echo $item->id . $isCancelled; ?>">
					<?php // Manager Icons ?>
					<?php if ($item->managerToolBar) : ?>
						<div class="ic-manager-toolbar">
							<?php echo $item->managerToolBar; ?>
						</div>
					<?php endif; ?>

					<?php // Load template to display each event in the list ?>
					<?php require $this->themeList; ?>
				</div>

			<?php endforeach; ?>
		</div>

		<?php // AddThis buttons // @deprecated 3.8.18 - removed 4.0 ?>
		<?php if ($this->params->get('atlist', 0) && $this->sharing) : ?>
			<div class="share ic-clearfix">
				<?php echo $this->sharing; ?>
			</div>
		<?php endif; ?>

		<?php // Navigation & pagination ?>
		<?php if ( in_array($this->params->get('navposition', 1), array('1', '2')) ) : ?>
			<div class="ic-clearfix">
				<?php echo $this->pagination; ?>
			</div>
			<br />
		<?php endif; ?>

	</form>
	<?php // End List of events ?>

	<?php // Content is generated by content plugin event "iCagendaOnListAfterDisplay" ?>
	<?php echo $this->event->iCagendaOnListAfterDisplay; ?>

</div>
