<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-12-26
 *
 * @package     iCagenda.Site
 * @subpackage  Layout
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       4.0
 *----------------------------------------------------------------------------
*/

\defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var  boolean  noparticipants  True if no participants.
 * @var  integer  toggle          Toggle effect.
 * @var  integer  display         Display type (full, avatar & name or name/username).
 * @var  integer  columns         Number of columns (full only).
 * @var  array    participants    Array of participants (avatar, name, tickets booked, date booked).
 * @var  array    theme           iCagenda theme slug.
 */

// Load iC Accordion script
HTMLHelper::_('script', 'com_icagenda/iCaccordion.js', ['relative' => true, 'version' => 'auto'], ['defer' => 'defer']);

$user = Factory::getApplication()->getIdentity();
?>

<div id="ic_event_participants" class="ic-event-participants <?php echo $theme; ?>">
<?php if ($toggle) : ?>
	<details>
		<summary class="ic-summary"><h3><?php echo Text::_('COM_ICAGENDA_EVENT_LIST_OF_PARTICIPANTS'); ?></h3></summary>
		<div class="ic-details-content">
<?php else : ?>
	<div class="ic-participants-header"><h3><?php echo Text::_('COM_ICAGENDA_EVENT_LIST_OF_PARTICIPANTS'); ?></h3></div>
<?php endif; ?>

	<?php if ($noparticipants) : ?>
		<?php echo Text::_('COM_ICAGENDA_NO_REGISTRATION'); ?>
	<?php else : ?>

		<?php if ($display === 1 || $display === 2) : ?>

			<?php if ($display === 1) : ?>
				<div class="ic-row ic-row-cols-<?php echo $columns; ?>">
			<?php elseif ($display === 2) : ?>
				<ul class="ic-row ic-row-cols-auto ic-list-inline">
			<?php endif; ?>
			<?php foreach ($participants as $participant) : ?>
				<?php if ($display === 1) : ?>
					<div class="ic-row-col">
						<div class="ic-card-participant">
							<div class="ic-card-participant-main">
								<div class="ic-participant-avatar ic-card-avatar">
									<?php echo $participant['avatar']; ?>
								</div>
								<div class="ic-participant-info">
									<span class="ic-participant-name"><?php echo $participant['name']; ?></span>
									<span class="visually-hidden"><?php echo Text::_('COM_ICAGENDA_REGISTRATION_PEOPLE_LABEL'); ?></span>
									<span class="ic-participant-tickets" title="<?php echo Text::_('COM_ICAGENDA_REGISTRATION_PEOPLE_LABEL'); ?>"><?php echo $participant['tickets']; ?></span>
									<br>
									<small class="ic-participant-date"><?php echo $participant['date']; ?></small>
								</div>
							</div>
							<?php $custom_fields = []; ?>
							<?php
							// Check access
							$groups   = $user->getAuthorisedViewLevels();
							$iCparams = ComponentHelper::getComponent('com_icagenda')->getParams();
							$global_show_participants_list   = $iCparams->get('show_cf_in_participants_list', 0);
							$global_access_participants_list = $iCparams->get('access_cf_in_participants_list', 3);
							?>
							<?php foreach ($participant['custom_fields'] as $k => $cf) : ?>
								<?php
								$CFparams = json_decode($cf->params);
								$CFshow   = ($CFparams->show_cf_in_participants_list != '') ? $CFparams->show_cf_in_participants_list : $global_show_participants_list;
								$CFaccess = ($CFparams->access_cf_in_participants_list != '') ? $CFparams->access_cf_in_participants_list : $global_access_participants_list;
								?>
								<?php if ($CFshow && \in_array($CFaccess, $groups)) : ?>
									<?php
									$custom_fields[]= '<span class="ic-cf-label">' . Text::_($cf->title) . ': </span>'
										. '<span class="ic-cf-value">' . Text::_($cf->value) . '</span><br>';
									?>
								<?php endif; ?>
							<?php endforeach; ?>
							<?php if (\count($custom_fields) > 0) : ?>
								<div class="ic-card-participant-cf">
									<?php foreach ($custom_fields as $field) : ?>
										<?php echo $field; ?>
									<?php endforeach; ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
				<?php elseif ($display === 2) : ?>
					<li class="ic-row-col">
						<div class="ic-list-avatar">
							<div class="ic-participant-avatar">
								<?php echo $participant['avatar']; ?>
							</div>
							<div class="ic-participant-name">
								<?php echo $participant['name']; ?>
							</div>
						</div>
					</li>
				<?php endif; ?>
			<?php endforeach; ?>
			<?php if ($display === 1) : ?>
				</div>
			<?php elseif ($display === 2) : ?>
				</ul>
			<?php endif; ?>

		<?php elseif ($display === 3) : ?>

			<div class="ic-participants-list">
				<?php echo $participants['list_participants']; ?>
			</div>
		<?php endif; ?>
	<?php endif; ?>

<?php if ($toggle) : ?>
			</div>
		</details>
	</div>
<?php endif; ?>
