<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-10-30
 *
 * @package     iCagenda.Admin
 * @subpackage  Utilities.Field.Icagenda
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.8.0
 *----------------------------------------------------------------------------
*/

namespace iCutilities\Field\Icagenda;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Custom Field Groups Filter Field
 */
class FilterCustomfieldGroupsField extends ListField
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 */
	protected $type = 'FilterCustomfieldGroups';

	/**
	 * Method to get the field options.
	 *
	 * @return  array  The field option objects.
	 */
	protected function getOptions()
	{
		$db = Factory::getContainer()->get(\Joomla\Database\DatabaseInterface::class);

		$query = $db->createQuery();

		$query->select('f.value, f.option')
			->from('#__icagenda_filters AS f')
			->where('f.type = "customfield"')
			->where('f.filter = "groups"')
			->order('f.option ASC');

		$db->setQuery($query);

		$groups = $db->loadObjectList();

		$list = [];

		foreach ($groups as $g) {
			$list[$g->value] = $g->option;
		}

		return array_merge(parent::getOptions(), $list);
	}
}
