<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-11-09
 *
 * @package     iCagenda.Admin
 * @subpackage  Utilities.Field.Icagenda
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       4.0
 *----------------------------------------------------------------------------
*/

namespace iCutilities\Field\Icagenda;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Form\FormField;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class OnlyProField extends FormField
{
	/**
	 * The form field type.
	 */
	protected $type = 'onlyPro';

	protected $extension = 'icagenda';

	protected function getInput()
	{
		$label      = $this->element['label'];
		$bydefault  = isset($this->element['bydefault']) ? $this->element['bydefault'] : '';
		$inlineHelp = isset($this->element['infopro']) ? $this->element['infopro'] : '';

		if (!$label && !$inlineHelp) {
			return '';
		}

		if ($bydefault) {
			$bydefault = '<small class="form-text">' . Text::_('JDEFAULT') . '</small> <span class="badge text-bg-info">' . Text::_($bydefault) . '</span>';
		}

		if ($inlineHelp) {
			$inlineHelp = '<div id="' . $this->id . '-desc" class="hide-aware-inline-help d-none">'
				. '<small class="form-text">' . Text::_($inlineHelp) . '</small>'
				. '</div>';
		}

		return '<div class="pt-1">' . $this->getText() . '</div>' . $bydefault . $inlineHelp;
	}

	protected function getLabel()
	{
		$label = $this->element['label'];
		$description = $this->element['infopro'];

		if (!$label && !$description) {
			return '</div><div>' . $this->getText();
		}

		return parent::getLabel();
	}

	protected function getText()
	{
		$text = Text::_('JOOMLIC_ONLY_AVAILABLE_IN_PRO');
		$text = '<em>' . $text . '</em>';
		$extension = $this->extension;

		if (!$extension) {
			return $text;
		}

		return '<a href="https://www.joomlic.com/extensions/' . $extension . '" rel="noopener" target="_blank"> ' . $text . '</a>';
	}
}
