<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-06-10
 *
 * @package     iCagenda.Admin
 * @subpackage  tmpl.themes
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       2.0
 *----------------------------------------------------------------------------
*/

\defined('_JEXEC') or die;

use iCutilities\Theme\Theme as icagendaTheme;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

// Check Theme Packs Compatibility
icagendaTheme::checkThemePacks();
?>

<div id="container">
	<div class="row">
		<div class="col col-lg-12">
			<div class="card mb-3">
				<div class="card-body">
					<form enctype="multipart/form-data" action="index.php" method="post" name="adminForm" id="themes-form" class="form-validate">
						<div class="form-group">
							<label for="install_package" class="mt-2 pb-1"><strong><?php echo Text::_('COM_ICAGENDA_THEMES_INSTALL_LBL'); ?></strong></label>
							<div class="input-group">
								<input type="file" id="sfile-upload" class="form-control" name="Filedata" />
								<button onclick="submitbutton()" class="btn btn-primary" id="upload-submit">
									<span class="icon-upload icon-white"></span> <?php echo Text::_('COM_ICAGENDA_UPLOAD_AND_INSTALL'); ?>
								</button>
							</div>
							<small class="form-text">
								<?php echo Text::_('COM_ICAGENDA_THEMES_INSTALL_DESC'); ?>
							</small>
						</div>
						<input type="hidden" name="type" value="" />
						<input type="hidden" name="option" value="com_icagenda" />
						<input type="hidden" name="task" value="themes.themeinstall" />
						<?php echo HTMLHelper::_('form.token'); ?>
					</form>
				</div>
			</div>
		</div>
		<div class="col col-12">
			<div class="card mb-3">
				<div class="card-header ic-card-header">
					<h2 class="text-light h3">
						<span class="iCicon-themes text-white-50 me-1"></span> <?php echo Text::_('COM_ICAGENDA_THEMES_LIST_TITLE'); ?>
					</h2>
				</div>
				<div class="card-body ic-bg-grey-light">
					<?php echo HTMLHelper::_('themes.list'); ?>
				</div>
			</div>
		</div>
	</div>
	<?php echo LayoutHelper::render('icagenda.admin.footer'); ?>
</div>
