<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.9.0 2024-02-24
 *
 * @package     iCagenda.Site
 * @subpackage  tmpl.submit
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.2
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

use iCutilities\Maps\Google\Search as icagendaMapsGoogleSearch;
use iCutilities\Maps\Leaflet\Search as icagendaMapsLeafletSearch;
use iCutilities\Customfields\Customfields as icagendaCustomfields;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive')
	->useScript('form.validate')
	->addInlineScript('
		window.addEventListener("load", function() {
			document.formvalidator.setHandler("positiveinteger", function(value, element) {
				value = punycode.toASCII(value);
				var regex = /^[1-9]\d*$/;
				return regex.test(value);
			});
		});
	');


HTMLHelper::_('script', 'com_icagenda/icform.js', array('relative' => true, 'version' => 'auto'), array('async' => 'async'));

HTMLHelper::_('stylesheet', 'com_icagenda/icagenda.css', array('relative' => true, 'version' => 'auto'));

$app      = Factory::getapplication();
$document = Factory::getDocument();

$document->addScriptDeclaration('
	var limitSize = "' . $this->params->get('submit_imageMaxSize', '800') . '";
');

// Create shortcuts to some parameters.
$maps_service = $this->params->get('maps_service', 1);

// Form Validation
if ($this->submit_form_validation == 1)
{
	$novalidate    = ' novalidate';
	$form_validate = '';
	$iCheckForm    = '';
}
else
{
	$novalidate    = '';
	$form_validate = ' form-validate';
	$iCheckForm    = '';

//	$iCheckForm    = ' onclick="iCheckForm();"';

	// Script validation for Submit Event form (2)
//	$formScript = icagendaForm::submit(2);
//	Factory::getDocument()->addScriptDeclaration($formScript);

//	// Needs globalization for rendered format...
//	Factory::getDocument()->addScriptDeclaration("
//		jQuery(document).ready(function(){
//			document.formvalidator.setHandler('date', function(value) {
//				regex=/^\d{4}-\d{2}-\d{2}\ \d{2}:\d{2}$/;
//				return regex.test(value);
//			});
//		});

//		function strpos (haystack, needle, offset) {
//			var i = (haystack + '').indexOf(needle, (offset || 0));
//			return i === -1 ? false : i;
//		}

//			var nodate = '0';
//			var noserialdate = 'a:1:{i:0;s:19:\"0000-00-00 00:00:00\";}';
//			var noserialdate2 = 'a:1:{i:0;s:16:\"0000-00-00 00:00\";}';
//			var emptydatetime = '0000-00-00 00:00:00';

//			var startDate = document.getElementById('jform_startdate');
//			var endDate = document.getElementById('jform_enddate');
//			var Dates = document.getElementById('jform_dates');
//			var isValidStartDate = (startDate == '');
//			var isValidEndDate = strpos(endDate.value, nodate, 0);
//			var isValidSingleDate = strpos(Dates.value, nodate, 2);

//			if (endDate.value && !isValidEndDate)
//			{
//				alert(endDate.value);
//			}
//	");

//	$document->addScriptDeclaration("
//		function iCheckForm()
//		{
//			if (!document.formvalidator.isValid(document.getElementById('icagenda-submit')))
//			{
//				contentTop = document.getElementById('system-message-container');
//				contentTop.scrollIntoView();
//			}
//		}
//	");
}
?>

<div id="icagenda" class="ic-submit-view<?php echo $this->pageclass_sfx; ?>">

	<?php // Content is generated by content plugin event "iCagendaOnSubmitBeforeDisplay" ?>
	<?php echo $this->pluginEvent->iCagendaOnSubmitBeforeDisplay; ?>

	<?php // PAGE HEADING ?>
	<?php if (!$this->params->get('show_page_heading', 1)) : ?>
	<div class="page-header">
		<h1> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
	</div>
	<?php endif; ?>

	<?php // FIELDS REQUIRED INFO ?>
	<div class="ic-required-info">
		<small><?php echo Text::_('COM_ICAGENDA_FORM_REQUIRED_INFO'); ?></small>
	</div>

	<?php // START FORM ?>
	<form class="icagenda-form<?php echo $form_validate; ?>"
		id="icagenda-submit"
		action="<?php echo Route::_('index.php?option=com_icagenda&task=submit.submit'); ?>"
		method="post"
		enctype="multipart/form-data"<?php echo $novalidate; ?>
		>

		<?php // User Information ?>
		<?php $fields = $this->form->getFieldset('user'); ?>
		<?php if (count($fields) > 0) : ?>
			<fieldset>
				<legend><?php echo Text::_('COM_ICAGENDA_LEGEND_USERINFOS'); ?></legend>
				<br />

				<?php foreach ($fields as $field) : ?>
					<?php $emptyDesc = 'COM_ICAGENDA_SUBMIT_' . strtoupper($field->fieldname) . '_DESC'; ?>
					<?php if (Text::_($field->description) == $emptyDesc || $field->type == 'Note') : ?>
						<?php $field->description = ''; ?>
						<?php $this->form->setFieldAttribute($field->fieldname, 'description', ''); // Description Note, deprecated v3.9 ?>
					<?php endif; ?>
					<?php echo $field->renderField(); ?>
				<?php endforeach; ?>

			</fieldset>
		<?php endif; ?>

		<?php // Event Info ?>
		<?php $fields = $this->form->getFieldset('event'); ?>
		<?php if (count($fields)) : ?>
			<fieldset>
				<legend><?php echo Text::_('COM_ICAGENDA_LEGEND_NEW_EVENT'); ?></legend>
				<br />

				<?php foreach ($fields as $field) : ?>
					<?php $emptyDesc = 'COM_ICAGENDA_SUBMIT_' . strtoupper($field->fieldname) . '_DESC'; ?>
					<?php if (Text::_($field->description) == $emptyDesc || $field->type == 'Note') : ?>
						<?php $field->description = ''; ?>
						<?php $this->form->setFieldAttribute($field->fieldname, 'description', ''); // Description Note, deprecated v3.9 ?>
					<?php endif; ?>
					<?php echo $field->renderField(); ?>
				<?php endforeach; ?>

			</fieldset>
		<?php endif; ?>

		<?php // Event Dates ?>
		<?php $fields = $this->form->getFieldset('dates'); ?>
		<?php if (count($fields)) : ?>
			<fieldset>
				<legend><?php echo Text::_('COM_ICAGENDA_LEGEND_DATES'); ?></legend>
				<br />

				<?php foreach ($fields as $field) : ?>
					<?php $emptyDesc = 'COM_ICAGENDA_SUBMIT_' . strtoupper($field->fieldname) . '_DESC'; ?>
					<?php if ($field->type == 'Note' && $field->description == '') : ?>
						<?php echo $field->renderField(); // Label Note ?>
					<?php elseif ($field->type != 'Note') : ?>
						<?php if (Text::_($field->description) == $emptyDesc) : ?>
							<?php $field->description = ''; ?>
						<?php endif; ?>
						<?php echo ($field->fieldname == 'dates') ? $field->input : $field->renderField(); ?>
					<?php endif; ?>
				<?php endforeach; ?>

			</fieldset>
		<?php endif; ?>

		<?php // Event Description ?>
		<?php $fields = $this->form->getFieldset('description'); ?>
		<?php if (count($fields)) : ?>
			<fieldset>
				<legend><?php echo Text::_('COM_ICAGENDA_SUBMIT_DESCRIPTION_LEGEND'); ?></legend>
				<br />

				<?php foreach ($fields as $field) : ?>
					<?php $emptyDesc = 'COM_ICAGENDA_SUBMIT_' . strtoupper(str_replace('_title', '' , $field->fieldname)) . '_DESC'; ?>
					<?php if (Text::_($field->description) == $emptyDesc) : ?>
						<?php $this->form->setFieldAttribute($field->fieldname, 'description', ''); ?>
					<?php endif; ?>
					<?php echo $field->renderField(); ?>
				<?php endforeach; ?>

			</fieldset>
		<?php endif; ?>

		<?php // Event Information & Custom Fields ?>
		<?php $fields = $this->form->getFieldset('information'); ?>
		<?php $customFieldsLoader = icagendaCustomfields::loader(2); ?>
		<?php if (count($fields) || ($customFieldsLoader && $this->params->get('submit_customfieldsDisplay', 1))) : ?>
			<fieldset>
				<legend><?php echo Text::_('COM_ICAGENDA_LEGEND_INFORMATION'); ?></legend>
				<br />

				<?php // Load Information Fields ?>
				<?php if (count($fields)) : ?>
					<?php foreach ($fields as $field) : ?>
						<?php $emptyDesc = 'COM_ICAGENDA_SUBMIT_' . strtoupper($field->fieldname) . '_DESC'; ?>
						<?php if ($field->type != 'Note' || ($field->type == 'Note' && $field->description == '')) : ?>
							<?php if (Text::_($field->description) == $emptyDesc) : ?>
								<?php $field->description = ''; ?>
							<?php endif; ?>
							<?php echo $field->renderField(); ?>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>

				<?php // Load Custom fields - Event form (2) ?>
				<?php if ($customFieldsLoader && $this->params->get('submit_customfieldsDisplay', 1)) : ?>
					<?php $customfields = $this->form->getFieldset('customfields'); ?>
					<?php foreach ($customfields as $field) : ?>
						<?php echo $field->renderField(); ?>
					<?php endforeach; ?>
					<?php echo $customFieldsLoader; ?>
				<?php endif; ?>

			</fieldset>
		<?php endif; ?>

		<?php // Maps Field Set ?>
		<?php if ($this->params->get('submit_gmapDisplay', 1)) : ?>
			<fieldset>
				<legend><?php echo Text::_('COM_ICAGENDA_EVENT_MAP_LEGEND'); ?></legend>
				<br />

				<div id="icagenda-map">

					<?php if ( ! $maps_service) : ?>
					<div class="row">
						<div class="col-lg-12">
							<?php echo $this->form->renderField('address'); ?>
							<?php echo Text::_('COM_ICAGENDA_MAPS_SERVICE_NOT_AVAILABLE'); ?>
						</div>
					</div>

					<!-- LeafLet OpenStreetMap -->
					<?php elseif ($maps_service == '1') : ?>
					<div class="row">
						<div class="col-lg-12">
							<div class="icmap-address">
								<div class="control-group">
									<!--div class="control-label">
										<?php echo $this->form->getLabel('address'); ?>
									</div-->
									<div class="controls">
										<?php echo $this->form->getLabel('address'); ?>
										<div id="findbox"></div>
										<?php echo $this->form->getInput('address'); ?>
										<?php echo $this->form->renderField('address_note'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<br />
					<div class="row">
						<div class="col-lg-4">
							<div class="icmap-field">
								<?php echo $this->form->getInput('city'); ?>
							</div>
							<div class="icmap-field">
								<?php echo $this->form->getInput('country'); ?>
							</div>
							<div class="icmap-field">
								<?php echo $this->form->getInput('lat'); ?>
							</div>
							<div class="icmap-field">
								<?php echo $this->form->getInput('lng'); ?>
							</div>
						</div>
						<div class="col-lg-8">
							<div class="ic-map-container">
								<div class="ic-map-wrapper" id="ic-map-0"></div>
							</div>
						</div>
					</div>
					<?php icagendaMapsLeafletSearch::addJS('ic-map-0', 'jform_address'); ?>

					<!-- Google Maps Embed API -->
					<?php elseif ($maps_service == '2') : ?>
					<div class="row">
						<div class="col-lg-12">
							<div class="icmap-address">
								<div class="control-group">
									<div class="control-label">
										<?php echo $this->form->getLabel('address'); ?>
									</div>
									<div class="controls">
										<div class="input-group">
											<?php echo $this->form->getInput('address'); ?>
											<button class="btn btn-primary" type="button" onclick="checkGoogleMap(document.getElementById('jform_address').value)"><?php echo Text::_('IC_CHECK'); ?></button>
										</div>
										<?php $this->form->setFieldAttribute('address_note', 'class' , 'ic-input-note form-text'); ?>
										<?php echo $this->form->renderField('address_note'); ?>
									</div>
								</div>
							</div>
							<div class="ic-map-container">
								<div id="embed_map" class="ic-map-wrapper"></div>
							</div>
						</div>
					</div>
					<?php
					$apiKey = $this->params->get('googlemaps_embed_key', '');
					?>
					<?php icagendaMapsGoogleSearch::addEmbedJS('embed_map', 'jform_address', array('apiKey' => $apiKey)); ?>

					<!-- Google Maps Javascript API -->
					<?php elseif ($maps_service == '3') : ?>
					<div class="row">
						<div class="col-lg-12">
							<?php echo $this->form->renderField('address'); ?>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-4">
							<br />
							<div class="icmap-field">
								<?php echo $this->form->getInput('city'); ?>
							</div>
							<div class="icmap-field">
								<?php echo $this->form->getInput('country'); ?>
							</div>
							<div class="icmap-field">
								<?php echo $this->form->getInput('lat'); ?>
							</div>
							<div class="icmap-field">
								<?php echo $this->form->getInput('lng'); ?>
							</div>
							<br />
						</div>
						<div class="col-lg-8">
							<div class="ic-map-container">
								<div class="ic-reverse-geocode text-end">
									<label id="geo_label" for="reverseGeocode"><?php echo Text::_('COM_ICAGENDA_GOOGLE_MAPS_REVERSE'); ?></label>
									<select id="reverseGeocode">
										<option value="false" selected><?php echo Text::_('JNO'); ?></option>
										<option value="true"><?php echo Text::_('JYES'); ?></option>
									</select>
								</div>
								<div id="map" class="ic-map-wrapper"></div>
								<div id="legend" class="ic-map-legend"><?php echo Text::_('COM_ICAGENDA_GOOGLE_MAPS_LEGEND'); ?></div>
							</div>
						</div>
					</div>
					<?php
					$apiKey    = $this->params->get('googlemaps_browser_key', '');
					$apiClient = $this->params->get('googlemaps_client_id', '');
					?>
					<?php icagendaMapsGoogleSearch::addJS('map', 'jform_address', array('apiKey' => $apiKey, 'apiClient' => $apiClient)); ?>
					<?php endif; ?>

				</div>
				<br />

			</fieldset>
		<?php endif; ?>

		<?php // Registration option ?>
		<?php $fields = $this->form->getFieldset('registration'); ?>
		<?php if (count($fields) && $this->params->get('submit_regoptionsDisplay', 1)) : ?>
			<fieldset>
				<legend><?php echo Text::_('COM_ICAGENDA_REGISTRATION_OPTIONS'); ?></legend>
				<br />

				<?php echo $this->form->renderField('statutReg', 'params'); ?>
				<div class="row">
					<div class="col-6">
						<?php echo $this->form->renderField('maxReg', 'params'); ?>
					</div>
					<div class="col-6">
						<?php $this->form->setFieldAttribute('typeReg', 'label', '', 'params'); ?>
						<?php echo $this->form->renderField('typeReg', 'params'); ?>
					</div>
				</div>
				<?php echo $this->form->renderField('reg_deadline_time', 'params'); ?>
				<?php echo $this->form->renderField('reg_deadline', 'params'); ?>
				<?php echo $this->form->renderField('reg_deadline_info', 'params'); ?>

			</fieldset>
		<?php endif; ?>

		<?php // Terms & Conditions ?>
		<?php if ($this->params->get('tos', 1)) : ?>
			<legend><?php echo Text::_('COM_ICAGENDA_SUBMIT_CONSENT_TOS_LABEL'); ?></legend>
			<br />
			<?php echo $this->form->renderField('consent_tos', 'consent'); ?>
		<?php endif; ?>

		<?php // Extra Fields ?>
		<?php $fields = $this->form->getFieldset('extra'); ?>
		<?php if (count($fields)) : ?>
			<?php foreach ($fields as $field) : ?>
				<?php echo $field->renderField(); ?>
			<?php endforeach; ?>
		<?php endif; ?>

		<?php // Hidden Fields ?>
		<?php $fields = $this->form->getFieldset('hidden'); ?>
		<?php if (count($fields)) : ?>
			<?php foreach ($fields as $field) : ?>
				<?php if ($field->fieldname == 'itemid') : ?>
					<?php $this->form->setValue('itemid', null, $app->getMenu()->getActive()->id); ?>
				<?php elseif ($field->fieldname == 'itemid_title') : ?>
					<?php $this->form->setValue('itemid_title', null, $app->getMenu()->getActive()->title); ?>
				<?php endif; ?>
				<?php echo $this->form->getInput($field->fieldname); ?>
			<?php endforeach; ?>
		<?php endif; ?>

		<?php // Form Submit or Cancel ?>
		<div class="control-group" id="submit">
			<div class="controls">
				<button class="btn btn-primary validate" type="submit"<?php echo $iCheckForm; ?>>
					<?php echo Text::_('COM_ICAGENDA_EVENT_FORM_SUBMIT'); ?>
				</button>
				<input name="itemID" type="hidden" value="<?php echo $app->input->getInt('Itemid'); ?>" />
				<input name="option" type="hidden" value="com_icagenda" />
				<input name="task" type="hidden" value="submit.submit" />
				<?php echo HTMLHelper::_('form.token'); ?>
			</div>
		</div>
	</form>

	<?php // Content is generated by icagenda plugin event "iCagendaOnSubmitAfterDisplay" ?>
	<?php echo $this->pluginEvent->iCagendaOnSubmitAfterDisplay; ?>
</div>
