<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *              Module iC Calendar
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-06-11
 *
 * @package     iCagenda.Site
 * @subpackage  mod_iccalendar.Dispatcher
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       4.0
 *----------------------------------------------------------------------------
 */

namespace WebiC\Module\Calendar\Site\Dispatcher;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;
use Joomla\CMS\Helper\ModuleHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Dispatcher class for mod_iccalendar
 */
class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
	use HelperFactoryAwareTrait;

	/**
	 * Returns the layout data.
	 *
	 * @return  array
	 */
	protected function getLayoutData(): array
	{
		$data   = parent::getLayoutData();
		$params = $data['params'];

		$cacheParams               = new \stdClass();
		$cacheParams->cachemode    = '';
		$cacheParams->class        = $this->getHelperFactory()->getHelper('CalendarHelper');
		$cacheParams->method       = 'getDays';
		$cacheParams->methodparams = [$params, $data['app']];
		$cacheParams->modeparams   = md5(serialize($this->module->id));

		$data['list'] = ModuleHelper::moduleCache($this->module, $params, '$cacheParams');

		$data['startLevel'] = $data['list'] ? reset($data['list'])->getParent()->level : null;

		return $data;
	}
}
