/**
 * iCagenda v4.0.1 2026-01-17 (https://www.joomlic.com)
 * @copyright  (C) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license    GNU General Public License version 3 or later; see LICENSE.txt
 */

window.JoomliC = window.JoomliC || {};

(function(JoomliC, document) {
	"use strict";

	JoomliC.updateCalendar = (moduleid) => {
		const calendar  = document.querySelector('[data-modid="'+ moduleid +'"]');
		let monthSelect = document.querySelector('[data-month-id="'+ moduleid +'"]'),
			yearInput   = document.querySelector('[data-year-id="'+ moduleid +'"]');

		let modid  = moduleid ? moduleid : calendar.dataset.modid,
			params = calendar.dataset.calendarParams,
			month  = monthSelect.value,
			year   = yearInput.value;

		params = JSON.parse(params);

		JoomliC.changeMonth(modid, params, year, month);
	};

	JoomliC.changeMonth = (modid, params, year, month) => {
		const urlparams = JSON.stringify(params);
		const paths = Joomla.getOptions('system.paths');
		Joomla.request({
			url: `${paths ? `${paths.root}/index.php` : window.location.pathname}?option=com_ajax&module=icagenda_calendar&method=calendar&format=raw&modid=${modid}&params=${urlparams}&year=${year}&month=${month}`,
			method: 'GET',
			perform: true,
			onSuccess(data) {
				if (data.length !== 0) {
					const calendar = document.querySelector('[data-modid="'+ modid +'"]');
					calendar.innerHTML = data;
				}
			},
			onError(xhr) {
				Joomla.renderMessages(Joomla.ajaxErrorsMessages(xhr));
				const response = JSON.parse(xhr.response);
				Joomla.renderMessages({ 'error': [response.message] }, undefined, true);
			}
		});
		return false;
	};

	JoomliC.loadEvents = (modid, params, date) => {
		const paths = Joomla.getOptions('system.paths');
		Joomla.request({
			url: `${paths ? `${paths.root}/index.php` : window.location.pathname}?option=com_ajax&module=icagenda_calendar&method=events&format=raw&modid=${modid}&params=${params}&date=${date}`,
			method: 'GET',
			perform: true,
			onSuccess(data) {
				if (data.length !== 0) {
					let icDialog = document.querySelector('[data-dialog-id="'+ modid +'"]');
//					@TODO: Modal for events with options - open
//					icDialog.showModal();
					icDialog.show();

					const allowedHtml = {
						time: ['class'],
						button: ['class', 'style', 'onclick'],
						div: ['class', 'style'],
						dialog: ['style'],
						img: ['src', 'srcset', 'alt', 'title', 'width', 'height', 'class', 'style'],
						span: ['style', 'hidden']
					};
					icDialog.innerHTML = Joomla.sanitizeHtml(data, allowedHtml);
					let calendarBlock = document.querySelector('.ic-calendar-container');

					let style = calendarBlock.currentStyle || window.getComputedStyle(calendarBlock),
//						width    = calendarBlock.offsetWidth, // or use style.width
//						marginX  = parseFloat(style.marginLeft) + parseFloat(style.marginRight),
//						paddingX = parseFloat(style.paddingLeft) + parseFloat(style.paddingRight),
//						borderX  = parseFloat(style.borderLeftWidth) + parseFloat(style.borderRightWidth),
						height   = calendarBlock.offsetHeight, // or use style.height
						marginY  = parseFloat(style.marginTop) + parseFloat(style.marginBottom),
						paddingY = parseFloat(style.paddingTop) + parseFloat(style.paddingBottom),
						borderY  = parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);

					let dialogHeight = (height + marginY - paddingY + borderY + 3);

					icDialog.style.height = dialogHeight+"px";
//					icDialog.style.width = dialogWidth+"px";
					const closeButton = document.querySelector('#dialog-close');

					closeButton.addEventListener("click", () => {
//						icDialog.style.display = 'none';
						icDialog.innerHTML = '';
						icDialog.close();
					});
					document.addEventListener('keyup', function (event) {
						if (event.key === "Escape") {
							icDialog.close();
						}
					});

					// Click outside the dialog close it.
					window.addEventListener('click', function(e) {
						var element = document.querySelector('.ic-calendar-container');

						if (e.target !== element && !element.contains(e.target)) {
							icDialog.close();
						}
					});
				}
			},
			onError(xhr) {
				Joomla.renderMessages(Joomla.ajaxErrorsMessages(xhr));
				const response = JSON.parse(xhr.response);
				Joomla.renderMessages({ 'error': [response.message] }, undefined, true);
			}
		});
		return false;
	};

}(JoomliC, document));
