<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.1 2026-01-19
 *
 * @package     iCagenda.Admin
 * @subpackage  src.View
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       1.0
 *----------------------------------------------------------------------------
*/

namespace WebiC\Component\iCagenda\Administrator\View\Icagenda;

use iCutilities\Categories\Categories as icagendaCategories;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Uri\Uri;
use WebiC\Component\iCagenda\Administrator\Helper\iCagendaHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * iCagenda Control Panel HTML view class.
 */
class HtmlView extends BaseHtmlView
{
	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		/** @var IcagendaModel $model */
		$model                = $this->getModel();
		$this->systemParams   = $model->getIcagendaSystemParams();
		$this->categoryStats  = $model->getCategoryStats();
		$this->eventStats     = $model->getEventStats();
		$this->eventHitsTotal = $model->getEventHitsTotal();

		$user = $this->getCurrentUser();
		$this->manageButtons    = $this->getManageButtons($user);
		$this->customizeButtons = $this->getCustomizeButtons($user);
		$this->setupButtons     = $this->getSetupButtons($user);

		// Add Charts.js
		Factory::getDocument()->addScript(Uri::root( true ) . '/media/com_icagenda/js/Chart.min.js');

		// Check for errors.
		if (\count($errors = $this->get('Errors'))) {
			throw new GenericDataException(implode("\n", $errors), 500);

			return false;
		}

		$this->addToolbar();

		parent::display($tpl);
	}
	/**
	 * Prepare view data
	 *
	 * @return  void
	 *
	 * @since 6.0.0
	 */
//	protected function initializeView()
//	{
//		parent::initializeView();

		/** @var IcagendaModel $model */
//		$model                = $this->getModel();
//		$this->systemParams   = $model->getIcagendaSystemParams();
//		$this->categoryStats  = $model->getCategoryStats();
//		$this->eventStats     = $model->getEventStats();
//		$this->eventHitsTotal = $model->getEventHitsTotal();

//		$user = $this->getCurrentUser();
//		$this->manageButtons    = $this->getManageButtons($user);
//		$this->customizeButtons = $this->getCustomizeButtons($user);
//		$this->setupButtons     = $this->getSetupButtons($user);

		// Add Charts.js
//		Factory::getDocument()->addScript(Uri::root( true ) . '/media/com_icagenda/js/Chart.min.js');

		// Check for errors.
//		if (\count($errors = $this->get('Errors'))) {
//			throw new GenericDataException(implode("\n", $errors), 500);

//			return false;
//		}

//		$this->addToolbar();
//	}

	/**
	 * Add the page title and toolbar.
	 */
	protected function addToolbar()
	{
		$app      = Factory::getApplication();
		$document = Factory::getDocument();

		$state = $this->get('State');
		$canDo = iCagendaHelper::getActions($state->get('filter.category_id'));

		$logo_icagenda_url = '../media/com_icagenda/images/iCagenda-brand-light.svg';

		if (file_exists($logo_icagenda_url)) {
			$logo_icagenda = '<img src="' . $logo_icagenda_url . '" width="160" height="30" alt="iCagenda" />';
		} else {
			$logo_icagenda = 'iCagenda :: ' . Text::_('COM_ICAGENDA_TITLE_ICAGENDA') . '';
		}

		ToolbarHelper::title($logo_icagenda, 'icagenda');

		$icTitle = Text::_('COM_ICAGENDA_TITLE_ICAGENDA');

		$sitename = $app->getCfg('sitename');
		$title    = $app->getCfg('sitename') . ' - ' . Text::_('JADMINISTRATION') . ' - iCagenda: ' . $icTitle;

		$document->setTitle($title);

		if ($canDo->get('core.admin') || $canDo->get('core.options')) {
			ToolbarHelper::preferences('com_icagenda');
		}
	}

	/**
	 * Get Manage buttons.
	 *
	 * @since   4.0.0
	 */
	private function getManageButtons($user)
	{
		// Categories
		$temp = [
			'image' => 'iCicon-categories',
			'icon'  => '',
			'name'  => 'COM_ICAGENDA_PANEL_CATEGORY',
			'id'    => 'icagendacategory',
			'group' => 'iCagenda',
		];

		if ($user->authorise('icagenda.access.categories', 'com_icagenda')) {
			$temp['link']     = 'index.php?option=com_icagenda&view=categories';
		} else {
			$temp['class']    = 'disabled';
			$temp['classadd'] = 'disabled';
		}

		if ($user->authorise('icagenda.access.categories', 'com_icagenda')
			&& $user->authorise('core.create', 'com_icagenda')
		) {
			$temp['linkadd'] = 'index.php?option=com_icagenda&view=icategory&layout=edit';
		}

		$manageButtons[]= $temp;

		// Events
		$temp = [
			'image' => 'iCicon-events',
			'icon'  => '',
			'name'  => 'COM_ICAGENDA_PANEL_EVENTS',
			'id'    => 'icagendaevent',
			'group' => 'iCagenda',
		];

		if ($user->authorise('icagenda.access.events', 'com_icagenda')) {
			$temp['link']     = 'index.php?option=com_icagenda&view=events';
		} else {
			$temp['class']    = 'disabled';
			$temp['classadd'] = 'disabled';
		}

		if ($user->authorise('icagenda.access.events', 'com_icagenda')
			&& $user->authorise('core.create', 'com_icagenda')
			&& icagendaCategories::getList('1')
		) {
			$temp['linkadd'] = 'index.php?option=com_icagenda&view=event&layout=edit';
		}

		$manageButtons[]= $temp;

		// Registrations
		$temp = [
			'image' => 'iCicon-registrations',
			'icon'  => '',
			'name'  => 'COM_ICAGENDA_PANEL_REGISTRATION',
			'id'    => 'icagendaregistration',
			'group' => 'iCagenda',
		];

		if ($user->authorise('icagenda.access.registrations', 'com_icagenda')) {
			$temp['link']     = 'index.php?option=com_icagenda&view=registrations';
		} else {
			$temp['class']    = 'disabled';
			$temp['classadd'] = 'disabled';
		}

//		if ($user->authorise('icagenda.access.registrations', 'com_icagenda')
//			&& $user->authorise('core.create', 'com_icagenda')
//		) {
//			$temp['linkadd'] = 'index.php?option=com_icagenda&view=registration&layout=edit';
//		}

		$manageButtons[]= $temp;

		// Mass Mail Registrants
		$temp = [
			'image' => 'iCicon-newsletter',
			'icon'  => '',
			'name'  => 'COM_ICAGENDA_PANEL_MASS_MAIL',
			'id'    => 'icagendamassmail',
			'group' => 'iCagenda',
		];

		if ($user->authorise('icagenda.access.newsletter', 'com_icagenda')) {
			$temp['link']     = 'index.php?option=com_icagenda&view=mail&layout=edit';
		} else {
			$temp['class']    = 'disabled';
			$temp['classadd'] = 'disabled';
		}

		$manageButtons[]= $temp;

		return $manageButtons;
	}

	/**
	 * Get Customize buttons.
	 *
	 * @since   4.0.0
	 */
	private function getCustomizeButtons($user)
	{
		// Custom Fields
		$temp = [
			'image' => 'iCicon-customfields',
			'icon'  => '',
			'name'  => 'COM_ICAGENDA_PANEL_CUSTOMFIELDS',
			'id'    => 'icagendacustomfields',
			'group' => 'iCagenda',
		];

		if ($user->authorise('icagenda.access.customfields', 'com_icagenda')) {
			$temp['link']     = 'index.php?option=com_icagenda&view=customfields';
		} else {
			$temp['class']    = 'disabled';
			$temp['classadd'] = 'disabled';
		}

		if ($user->authorise('icagenda.access.customfields', 'com_icagenda')
			&& $user->authorise('core.create', 'com_icagenda')
		) {
			$temp['linkadd'] = 'index.php?option=com_icagenda&view=customfield&layout=edit';
		}

		$customizeButtons[]= $temp;

		// Feature Tags
		$temp = [
			'image' => 'iCicon-features',
			'icon'  => '',
			'name'  => 'COM_ICAGENDA_PANEL_FEATURES',
			'id'    => 'icagendafeatures',
			'group' => 'iCagenda',
		];

		if ($user->authorise('icagenda.access.features', 'com_icagenda')) {
			$temp['link']     = 'index.php?option=com_icagenda&view=features';
		} else {
			$temp['class']    = 'disabled';
			$temp['classadd'] = 'disabled';
		}

		if ($user->authorise('icagenda.access.features', 'com_icagenda')
			&& $user->authorise('core.create', 'com_icagenda')
		) {
			$temp['linkadd'] = 'index.php?option=com_icagenda&view=feature&layout=edit';
		}

		$customizeButtons[]= $temp;

		return $customizeButtons;
	}

	/**
	 * Get Setup buttons.
	 *
	 * @since   4.0.0
	 */
	private function getSetupButtons($user)
	{
		// Global Options
		$temp = [
			'image' => 'icon-options',
			'icon'  => '',
			'name'  => 'JTOOLBAR_OPTIONS',
			'id'    => 'icagendaoptions',
			'group' => 'iCagenda',
		];

		if ($user->authorise('core.admin', 'com_icagenda')) {
			$temp['link']     = 'index.php?option=com_config&view=component&component=com_icagenda&path=&return=' . base64_encode(Uri::getInstance()->toString());
		} else {
			$temp['class']    = 'disabled';
			$temp['classadd'] = 'disabled';
		}

		$setupButtons[]= $temp;

		// Theme Packs
		$temp = [
			'image' => 'iCicon-themes',
			'icon'  => '',
			'name'  => 'COM_ICAGENDA_PANEL_THEMES',
			'id'    => 'icagendathemes',
			'group' => 'iCagenda',
		];

		if ($user->authorise('core.admin', 'com_icagenda')) {
			$temp['link']     = 'index.php?option=com_icagenda&view=themes';
		} else {
			$temp['class']    = 'disabled';
			$temp['classadd'] = 'disabled';
		}

		$setupButtons[]= $temp;

//		$setupButtons[]= [
//			'link'  => 'index.php?option=com_icagenda&view=info',
//			'image' => 'iCicon-information',
//			'icon'  => '',
//			'name'  => 'COM_ICAGENDA_INFO',
//			'id'    => 'icagendainfo',
//			'group' => 'iCagenda',
//		];

		return $setupButtons;
	}

	/**
	 * Save iCagenda Params
	 *
	 * Update Database
	 *
	 * @since   3.3.8
	 */
	public function saveDefault($var, $name, $value)
	{
		if ($var) {
			$params[$name] = $value;

			$model = $this->getModel();
			$model->updateSystemParams($params);
		}
	}

	/**
	 * Check Deprecated Extensions status
	 *
	 * @param   array  $elements  list of deprecated extensions (by element).
	 *
	 * @return  array  [element => ['enabled' => boolean, 'published' => boolean]]
	 *
	 * @since   4.0.0
	 */
	public function checkDeprecatedStatus($elements)
	{
		if (\is_array($elements) && !empty($elements)) {
			$model = $this->getModel();
			$exts = $model->getDeprecatedExtensions($elements);

			return $exts;
		}
	}

	public function updateSiteID($element)
	{
		$element = $element ?: 'pkg_icagenda';

		$model = $this->getModel();
		$usid  = $model->getUpdateSiteID($element);

		return $usid;
	}
}
