<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-06-11
 *
 * @package     iCagenda.Admin
 * @subpackage  tmpl.icagenda
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       1.0
 *----------------------------------------------------------------------------
*/

\defined('_JEXEC') or die();

class iCagendaUpdateLogsColoriser
{
	public static function colorise($file, $onlyLast = false)
	{
		$ret = '';

		$lines = @file($file);

		if (empty($lines)) return $ret;

		array_shift($lines);
		$first = false;

		foreach($lines as $line) {
			$line = trim($line);

			if (empty($line)) continue;

			$type = substr($line, 0, 1);

			switch ($type) {
				case '=':
					break;

				case ':':
					$first = true;
					$ret.= "\t".'<div style="font-size: .875rem;"><b>Legend: </b>'.trim(substr($line, 1))."</div>\n";
					break;

				case '?':
					$ret.= "\t".'<div class="mt-2" style="font-size: .75rem;"><b>Info: </b>' . trim(substr($line, 1)) . "</div>\n";
					break;
	
				case '!':
					$ret.= "\t".'<li class="ic-bold ic-important"><div class="ic-box-16 ic-box-important">!</div>'
						. htmlentities(trim(substr($line,2))) . "</li>\n";
					break;

				case '1':
					$ret.= "\t".'<li class="ic-changelog-important-sub"><span></span> '.trim(substr($line,2))."</li>\n";
					break;

				case '+':
					$ret.= "\t".'<li class="ic-added"><div class="ic-box-16 ic-box-added">+</div>'
						. htmlentities(trim(substr($line,2))) . "</li>\n";
					break;

				case '-':
					$ret.= "\t".'<li class="ic-removed"><div class="ic-box-16 ic-box-removed">-</div>'
						. htmlentities(trim(substr($line,2))) . "</li>\n";
					break;

				case '~':
					$ret.= "\t".'<li class="ic-changed"><div class="ic-box-16 ic-box-changed">~</div>'
						. htmlentities(trim(substr($line,2))) . "</li>\n";
					break;

				case '#':
					$ret.= "\t".'<li class="ic-fixed"><div class="ic-box-16 ic-box-fixed">#</div>'
						. htmlentities(trim(substr($line,2))) . "</li>\n";
					break;

//				case 'H':
//					$ret.= "\t".'<li class="ic-fixed"><div class="ic-box-16 ic-box-fixed">#</div><div class="ic-box ic-box-removed">HIGH</div> '
//						. htmlentities(trim(substr($line,2))) . "</li>\n";
//					break;

				case '*':
					$ret.= "\t".'<h4 class="ic-changelog">' . htmlentities(trim(substr($line,2))) . "</h4>\n";
					break;

				case '$':
					$ret.= "</ul>";
					$ret.= "<h3 class=\"ic-changelog-pro\">&nbsp;&nbsp;" . substr($line,2) . " <SUP>[ PRO Testing ]</SUP></h3>\n";
					$ret.= "<ul class=\"ic-changelog\">\n";
					break;

				// End
				case ';':
					$ret.= "</ul>";
					break;

				default:

					if (!empty($ret)) {
						$ret.= "</ul>";
						if ($onlyLast) return $ret;
					}

					if (!$onlyLast) $ret.= "<h3 class=\"ic-changelog\">&nbsp;&nbsp;$line</h3>\n";

					if ($first) {
						$ret.= "<ul class=\"ic-changelog\">\n";
					} else {
						$ret.= "<ul class=\"ic-changelog\" style=\"background-color: rgba(100,100,100,.05)\">\n";
					}

					break;
			}
		}

		return $ret;
	}
}
