<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.1 2026-01-19
 *
 * @package     iCagenda.Admin
 * @subpackage  tmpl.icagenda
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       1.0
 *----------------------------------------------------------------------------
*/

\defined('_JEXEC') or die;

use iCutilities\Categories\Categories as icagendaCategories;
use iCutilities\Update\icagendaUpdate;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

// Get Application
$app = Factory::getApplication();

$params       = ComponentHelper::getParams('com_icagenda');
$systemParams = json_decode($this->systemParams, true);
?>

<div id="container">
	<div class="row">
		<div class="col col-lg-6">
			<div class="card mb-3">
				<div class="card-header ic-card-header">
					<h2 class="text-light h3">
						<span class="icon-calendar-2 text-white-50 me-1"></span> Manage
					</h2>
				</div>
				<div class="card-body p-0">
					<nav class="quick-icons px-3 py-3" aria-label="<?php echo Text::_('Quick Links: Manage'); ?>">
						<ul class="nav flex-wrap">
							<?php echo HTMLHelper::_('icons.buttons', $this->manageButtons); ?>
						</ul>
					</nav>
				</div>
			</div>

			<div class="card mb-3">
				<div class="card-header ic-card-header">
					<h2 class="text-light h3">
						<span class="icon-puzzle text-white-50 me-1"></span> Customize
					</h2>
				</div>
				<div class="card-body p-0">
					<nav class="quick-icons px-3 py-3" aria-label="<?php echo Text::_('Quick Links: Customize'); ?>">
						<ul class="nav flex-wrap">
							<?php echo HTMLHelper::_('icons.buttons', $this->customizeButtons); ?>
						</ul>
					</nav>
				</div>
			</div>

			<div class="card mb-3">
				<div class="card-header ic-card-header">
					<h2 class="text-light h3">
						<span class="icon-wrench text-white-50 me-1"></span> Setup
					</h2>
				</div>
				<div class="card-body p-0">
					<nav class="quick-icons px-3 py-3" aria-label="<?php echo Text::_('Quick Links: Setup'); ?>">
						<ul class="nav flex-wrap">
							<?php echo HTMLHelper::_('icons.buttons', $this->setupButtons); ?>
						</ul>
					</nav>
				</div>
			</div>

			<?php if (ICAGENDA_VARIANT == 'core' || ! ICAGENDA_VARIANT) : ?>
				<div class="mb-3 alert alert-info">

					<h2><?php echo Text::sprintf('COM_ICAGENDA_FREE_VERSION', 'iCagenda&trade;') ?></h2>
					<p>
						<?php echo Text::_('COM_ICAGENDA_FREE_WANT_MORE') ?>
					</p>
					<p>
						<strong><?php echo Text::_('COM_ICAGENDA_FREE_SUBSCRIBE_PRO') ?></strong>
					</p>
					<p class="text-start">
						<a href="https://www.joomlic.com/extensions/icagenda" class="btn btn-success text-light" title="<?php echo Text::_('COM_ICAGENDA_FREE_SUBSCRIBE_NOW'); ?>" role="button">
							<span class="icon-chevron-right"></span>&nbsp;&nbsp;<?php echo Text::_('COM_ICAGENDA_FREE_SUBSCRIBE_NOW'); ?>
						</a>
					</p>
					<p>
						<?php echo Text::_('COM_ICAGENDA_PANEL_PRO_VERSION') ?>:
						<ul>
							<li><?php echo Text::_('COM_ICAGENDA_PRO_PREMIUM_SUPPORT_LABEL') ?></li>
							<li><?php echo Text::_('COM_ICAGENDA_PANEL_PRO_MODULE_IC_EVENT_LIST') ?></li>
							<li><?php echo Text::_('COM_ICAGENDA_PANEL_PRO_PLUGIN_IC_PAYPAL') ?></li>
							<li><?php echo Text::_('COM_ICAGENDA_PANEL_PRO_FRONTEND_EDITION') ?></li>
							<li><?php echo Text::_('COM_ICAGENDA_PANEL_PRO_ITEM_VERSIONING') ?></li>
						</ul>
					</p>
				</div>
			<?php endif; ?>
		</div>

		<div class="col col-lg-6">
			<div class="card mb-3">
				<div class="card-body">
					<?php echo LayoutHelper::render('icagenda.admin.logo', ['version' => ICAGENDA_VARIANT]); ?>
				</div>
			</div>

			<div class="card mb-3">
				<div class="card-body p-3">
					<div class="ic-version-check">
						<div class="d-block d-sm-inline-block mb-2">
							iCagenda&nbsp;<?php echo ICAGENDA_VARIANT; ?>&nbsp;<strong><?php echo ICAGENDA_VERSION; ?></strong>&nbsp;<small>(<?php echo ICAGENDA_RELDATE; ?>)</small>
						</div>
						<div id="iCagendaLiveupdate" class="d-block d-sm-inline-block ps-0 ps-sm-1">
							<?php echo LayoutHelper::render('icagenda.updater.liveupdate', icagendaUpdate::checkUpdate()); ?>
						</div>
					</div>
					<br>

					<a data-bs-target="#changelog" title="<?php echo Text::_('COM_ICAGENDA_PANEL_UPDATE_LOGS'); ?>" data-bs-toggle="modal">
						<button type="button" class="btn btn-secondary"><?php echo Text::_('COM_ICAGENDA_PANEL_UPDATE_LOGS'); ?></button>
					</a>
					<?php
					echo HTMLHelper::_(
						'bootstrap.renderModal',
						'changelog',
						array(
							'title'       => Text::_('COM_ICAGENDA_PANEL_UPDATE_LOGS'),
							'url'         => Route::_('index.php?option=com_icagenda&view=icagenda&layout=default_modal_changelog&tmpl=component'),
							'height'      => '500px',
							'width'       => '600px',
							'bodyHeight'  => '70',
							'modalWidth'  => '60',
							'footer'      => '<button type="button" class="btn" data-bs-dismiss="modal">'
											. Text::_('JTOOLBAR_CLOSE') . '</button>',
						)
					);
					?>

					<?php
					// Set message variables
					$thisURL   = Uri::getInstance()->toString();
					$return_cp = 'index.php?option=com_icagenda';
					?>

					<?php
					// Deprecated module Calendar control (deprecated since January 2026)
					$deprecated_extensions = $this->checkDeprecatedStatus([
						['module', 'mod_iccalendar', ''],
						['plugin', 'icagenda', 'search'],
					]);

					if (\count($deprecated_extensions)) {
						$deprecatedParam = $app->getInput()->get('deprecated', '');

						if ($deprecatedParam == -1) {
							$this->saveDefault($deprecatedParam, 'msg_deprecated_extensions', '-1');
							$app->getMessageQueue(true);
							$app->enqueueMessage(Text::_('COM_ICAGENDA_MSG_HIDDEN_SUCCESS'), 'message');
							$app->redirect($return_cp);
						} elseif ($deprecatedParam == 1) {
							$this->saveDefault($deprecatedParam, 'msg_deprecated_extensions', '1');
							$app->getMessageQueue(true);
							$app->redirect($return_cp);
						}

						$msg_deprecated_extensions = isset($systemParams['msg_deprecated_extensions']) ? $systemParams['msg_deprecated_extensions'] : 1;

						if ($msg_deprecated_extensions == -1) {
							?>
							<a href="<?php echo Route::_($thisURL.'&deprecated=1') ?>">
								<button type="button" class="btn text-bg-warning" aria-labelledby="deprecated-reload"><span class="icon-warning" aria-hidden="true"></span> <?php echo Text::_('COM_ICAGENDA_BTN_DEPRECATED_EXTENSIONS_RELOAD'); ?></button>
								<div id="deprecated-reload" role="tooltip">
									<?php echo HTMLHelper::_('tooltipText', '', Text::_('COM_ICAGENDA_BTN_DEPRECATED_EXTENSIONS_DESC'), true, false); ?>
								</div>
							</a>
							<hr>
							<?php
						} else {
							$msgDeprecatedExts = '<h2>' . Text::_('COM_ICAGENDA_MSG_DEPRECATED_EXTENSIONS_TITLE') . '</h2>';
							$msgDeprecatedExts.= '<p>' . Text::_('COM_ICAGENDA_MSG_DEPRECATED_EXTENSIONS_INFO') . '</p>';

							foreach ($deprecated_extensions as $key => $deprecatedExt) {
								$msgDeprecatedExts.= '<div class="mb-3">';

								$stringKey = strtoupper($key);
								$isModule = (strpos($stringKey, 'MODULE') !== false);
								$isPlugin = (strpos($stringKey, 'PLUGIN') !== false);

								$badge = '';

								if ($isModule) {
									$badge = ' <span class="badge text-bg-danger">Module</span>';
								} elseif ($isPlugin) {
									$badge = ' <span class="badge text-bg-primary">Plugin</span>';
								}

								$msgDeprecatedExts.= '<h3>' . Text::_('COM_ICAGENDA_MSG_DEPRECATED_' . $stringKey . '_LABEL') . $badge . '</h3>';
								$msgDeprecatedExts.= '<p>' . Text::_('COM_ICAGENDA_MSG_DEPRECATED_' . $stringKey . '_DESC') . '</p>';

								if (strpos($stringKey, 'MODULE') !== false) {
									$modStatus = [
										'1'  => Text::_('JPUBLISHED'),
										'0'  => Text::_('JUNPUBLISHED'),
										'-2' => Text::_('JTRASHED'),
									];

									if (\count($deprecatedExt) > 0) {
										$msgDeprecatedExts.= Text::plural('COM_ICAGENDA_MSG_DEPRECATED_MODULES_LIST_LABEL', \count($deprecatedExt));
										$msgDeprecatedExts.= '<ul>';

										foreach ($deprecatedExt as $k => $depext) {
											if (isset($depext->title)) {
												$msgDeprecatedExts.= '<li><b>' . $depext->title . '</b> ' . Text::sprintf('COM_ICAGENDA_MSG_DEPRECATED_MODULES_LIST_MODULEID', $depext->moduleid, ($depext->position ?: Text::_('JNONE'))) . ' - <em>' . $modStatus[$depext->published] . '</em></li>';
											}
										}

										$msgDeprecatedExts.= '</ul>';
										$msgDeprecatedExts.= '<span class="icon-arrow-right-4" aria-hidden="true"></span> <a class="alert-link" href="index.php?option=com_modules&view=modules&client_id=0&filter[state]=*&filter[module]=' . $depext->element . '">' . Text::plural('COM_ICAGENDA_MSG_DEPRECATED_' . $stringKey . '_LINK', \count($deprecatedExt)) . '</a><br>';
									} else {
										$msgDeprecatedExts.= '<p class="fst-italic"><span class="iCicon-info-circle" aria-hidden="true"></span> ' . Text::sprintf('COM_ICAGENDA_MSG_DEPRECATED_MODULE_NONE_SET', Text::_('COM_ICAGENDA_MSG_DEPRECATED_' . $stringKey . '_LABEL')) . '</p>';
										$msgDeprecatedExts.= '<span class="icon-arrow-right-4" aria-hidden="true"></span> <a class="alert-link" href="index.php?option=com_installer&view=manage&filter[search]=ID:' . $deprecatedExt['extension_id'] . '">' . Text::_('COM_ICAGENDA_MSG_DEPRECATED_MODULE_UNINSTALL_LINK') . '</a><br>';
									}
								}

								if (strpos($stringKey, 'PLUGIN') !== false) {
									$msgDeprecatedExts.= '<span class="icon-arrow-right-4" aria-hidden="true"></span> <a class="alert-link" href="index.php?option=com_installer&view=manage&filter[search]=ID:' . $deprecatedExt['extension_id'] . '">' . Text::_('COM_ICAGENDA_MSG_DEPRECATED_PLUGIN_UNINSTALL_LINK') . '</a><br>';
								}

								$msgDeprecatedExts.= '</div>';
							}

							$msgDeprecatedExts.= '<div>'
								. '<a href="' . Route::_($thisURL.'&deprecated=-1') . '">'
								. '<div class="btn btn-info">' . Text::_('IC_HIDE_THIS_MESSAGE') . '</div>'
								. '</a>'
								. '</div>';

							$app->enqueueMessage($msgDeprecatedExts, 'warning');
						}
					}

					// AddThis Termination control (deprecated since June 2023)
					$addthis_removal     = $params->get('addthis_removal', '');
					$addthis_termination = $app->getInput()->get('addthis_termination', '');

					if ($addthis_termination == -1) {
						$this->saveDefault($addthis_termination, 'msg_addthis', '-1');
						$app->getMessageQueue(true);
						$app->enqueueMessage(Text::_('COM_ICAGENDA_MSG_HIDDEN_SUCCESS'), 'message');
						$app->redirect($return_cp);
					} elseif ($addthis_termination == 1) {
						$this->saveDefault($addthis_termination, 'msg_addthis', '1');
						$app->getMessageQueue(true);
						$app->redirect($return_cp);
					}

					$msg_addthis = isset($systemParams['msg_addthis']) ? $systemParams['msg_addthis'] : 1;
					?>
					<?php if ($msg_addthis == 1 && !$addthis_removal) : ?>
						<?php
						$app->enqueueMessage('<h2>' . Text::_('COM_ICAGENDA_MSG_ADDTHIS_TERMINATION_TITLE') . '</h2>'
							. '<p>' . Text::sprintf('COM_ICAGENDA_MSG_ADDTHIS_TERMINATION_STATEMENT', '<a href="https://www.addthis.com/" target="_blank" rel="noopener">' . Text::_('IC_READMORE') . '</a>') . '</p>'
							. '<p>' . Text::_('COM_ICAGENDA_MSG_ADDTHIS_TERMINATION_RESULT') . '</p>'
							. '<p>' . Text::sprintf('COM_ICAGENDA_MSG_ADDTHIS_TERMINATION_SOLUTIONS', '<a href="https://extensions.joomla.org/category/social-web/social-share/" target="_blank" rel="noopener">JED</a>') . '</p>'
							. '<p>' . Text::_('COM_ICAGENDA_MSG_ADDTHIS_TERMINATION_SORRY') . '</p>'
							. '<div>'
							. '<a href="' . Route::_($thisURL.'&addthis_termination=-1') . '">'
							. '<div class="btn btn-info">' . Text::_('IC_HIDE_THIS_MESSAGE') . '</div>'
							. '</a>'
							. '</div>'
							, 'warning');
						?>
					<?php endif; ?>

					<?php
					// PRO version welcome message
					?>
					<?php if (ICAGENDA_VARIANT == 'pro') : ?>
						<?php
						$welcome_pro =  $app->getInput()->get('welcome', '');

						if ($welcome_pro == -1) {
							$this->saveDefault($welcome_pro, 'msg_procp', '-1');
							$app->getMessageQueue(true);
							$app->enqueueMessage(Text::_('COM_ICAGENDA_WELCOME_HIDE_SUCCESS'), 'message');
							$app->redirect($return_cp);
						} elseif ($welcome_pro == 1) {
							$this->saveDefault($welcome_pro, 'msg_procp', '1');
							$app->getMessageQueue(true);
							$app->redirect($return_cp);
						}

						$updateSiteID = $this->updateSiteID('pkg_icagenda');

						if ($updateSiteID) {
							$updateSiteLink = '<a href="index.php?option=com_installer&task=updatesite.edit&update_site_id='
								. $updateSiteID . '">'
								. Text::_('COM_ICAGENDA_PRO_UPDATE_SITE_NAME') . '</a>';
						} else {
							$updateSiteLink = Text::_('COM_ICAGENDA_PRO_UPDATE_SITE_NAME');
						}

						$msg_procp = isset($systemParams['msg_procp']) ? $systemParams['msg_procp'] : 1;
						?>

						<?php if ($msg_procp == -1) : ?>
							<a href="<?php echo Route::_($thisURL.'&welcome=1') ?>">
								<button type="button" class="btn btn-outline-secondary" aria-labelledby="welcome-reload"><?php echo Text::_('COM_ICAGENDA_WELCOME_RELOAD'); ?></button>
								<div id="welcome-reload" role="tooltip">
									<?php echo HTMLHelper::_('tooltipText', '', Text::_('COM_ICAGENDA_WELCOME_RELOAD_DESC'), true, false); ?>
								</div>
							</a>
						<?php else : ?>
							<?php
							$app->enqueueMessage('<h2>' . Text::sprintf('COM_ICAGENDA_PRO_WELCOME', 'iCagenda PRO') . '</h2>'
								. '<p>' . Text::_('COM_ICAGENDA_PRO_WELCOME_THANK_YOU') . '</p>'
								. '<h3>' . Text::_('COM_ICAGENDA_PRO_WELCOME_UPDATE_INFO_LABEL') . '</h3>'
								. '<div>' . Text::sprintf('COM_ICAGENDA_PRO_WELCOME_UPDATE_INFO_WHERE', '<strong>' . Text::_('COM_ICAGENDA_PRO_UPDATE_KEY_NAME') . '</strong>', '<a href="https://www.joomlic.com/add-on-download-ids" rel="noopener" target="_blank">' . Text::_('COM_ICAGENDA_PRO_ACCOUNT_LABEL') . '</a>') . '</div>'
								. '<div>' . Text::sprintf('COM_ICAGENDA_PRO_WELCOME_UPDATE_SITE_HOW', $updateSiteLink, 'iCagenda PRO') . '</div>'
								. '<p><small><em>' . Text::sprintf('COM_ICAGENDA_PRO_WELCOME_UPDATE_INFO_NOTE', Text::_('COM_ICAGENDA_PRO_UPDATE_KEY_NAME')) . '</em></small></p>'
								. '<h3>' . Text::_('COM_ICAGENDA_PRO_PREMIUM_SUPPORT_LABEL') . '</h3>'
								. '<div>' . Text::_('COM_ICAGENDA_PRO_WELCOME_CONTACT') . '</div>'
								. '<div>' . Text::sprintf('COM_ICAGENDA_PRO_WELCOME_SUPPORT', '<a href="https://www.joomlic.com/support" target="_blank">Pro Ticket System</a>') . '</div>'
								. '<p><small><em>' . Text::sprintf('COM_ICAGENDA_PRO_WELCOME_CONTACT_NOTE', 'JoomliC') . '</em></small></p>'
								. '<div>'
								. '<a href="' . Route::_($thisURL.'&welcome=-1') . '">'
								. '<div class="btn btn-info">' . Text::_('IC_HIDE_THIS_MESSAGE') . '</div>'
								. '</a>'
								. '</div>'
								, 'notice');
							?>
						<?php endif; ?>
					<?php endif; ?>
				</div>
			</div>

			<div class="card mb-3">
				<?php
				// Statistics Charts
				Factory::getDocument()->addStyleDeclaration('
					.ic-canvas {
						width: 100% !important;
						height: auto !important;
					}
				');

				$charts = [
					'categoryStats' => [
						'title'      => Text::sprintf('COM_ICAGENDA_STATS_TOP_CATEGORIES_LBL', '10'),
						'title_note' => Text::_('COM_ICAGENDA_STATS_BASED_ON_ALL_EVENTS_HITS'),
					],
					'eventStats'    => [
						'title'      => Text::sprintf('COM_ICAGENDA_STATS_TOP_EVENTS_LBL', '10'),
						'title_note' => Text::_('COM_ICAGENDA_STATS_ON_EVENT_HITS'),
					],
				];

				$mbString = extension_loaded('mbstring');

				$script = '
				var schemeStrokeColor = "#fafbfe";

//				document.addEventListener("DOMContentLoaded", () => {

					const docEl = document.documentElement;

					// Update data-bs-theme when scheme has been changed
//					document.addEventListener("joomla:color-scheme-change", () => {
						currentColorScheme = docEl.dataset.colorScheme;
						console.log(currentColorScheme);
						if (currentColorScheme == "dark") {
							schemeStrokeColor = "#0f151d";
						} else {
							schemeStrokeColor = "#fafbfe";
						}
//					});

//				});
				';

				if ($this->eventHitsTotal) {
					echo '<script>' . $script . '</script>';
				}
				?>

				<div class="d-flex justify-content-between flex-column flex-md-row p-3 pb-0 gap-3">
					<?php foreach ($charts as $chart => $info) : ?>
						<div id="canvas-holder" class="text-center w-50">
							<div class="fs-4 fw-bold"><?php echo $info['title']; ?></div>
							<div class="fs-6 fw-light fst-italic mb-3"><?php echo $info['title_note']; ?></div>
							<?php if ($this->eventHitsTotal) : ?>
								<canvas id="<?php echo $chart; ?>_area" width="160" height="160" class="ic-canvas">Sorry, your browser does not support &lt;canvas&gt;.</canvas>
							<?php else : ?>
								<span><?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?></span>
							<?php endif; ?>
						</div>

						<?php
						$script = [];
						$legend = [];

						$script[]= 'var data = [';

						foreach ($this->{$chart} AS $v) {
							$percent = $this->eventHitsTotal ? ($v->hits / $this->eventHitsTotal) : 0;

							$script[]= '		{';
							$script[]= ($chart == 'categoryStats')
										? '			value: ' . round(( $percent * 100 ), 2) . ','
										:  '			value: ' . $v->hits . ',';
							$script[]= '			color: "' . $v->cat_color . '",';
							$script[]= '			highlight: "#777777",';

							$label_length = $mbString ? mb_strlen($v->stats_label, 'UTF-8') : strlen($v->stats_label);
							$label_cut    = $mbString ? mb_substr($v->stats_label, 0, 20, 'UTF-8') : substr($v->stats_label, 0, 20);

							$stats_label  = $label_cut;
							$stats_label .= ($label_length > 20) ? '...' : '';

							$script[]= '			label: "' . addslashes($stats_label) . '"';
							$script[]= '		},';

							$legend_data = addslashes($v->cat_title) . '@@' . $v->cat_color;

							if ( ! in_array($legend_data, $legend)) {
								$legend[]= $legend_data;
							}
						}

						sort($legend);

						$script[]= '	];';

						// Chart Options
						$script[]= 'var options = {';
						$script[]= '	animationEasing : "easeInOutBack",';
						$script[]= '	animationSteps : 60,';
						$script[]= '	responsive : true,';
						$script[]= '	segmentStrokeColor : schemeStrokeColor, segmentShowStroke : true,';
						$script[]= ($chart == 'categoryStats')
									? '	percentageInnerCutout : 0, tooltipTemplate: "<%if (label){%><%=label%> | <%}%><%= value %>%"'
									: '	percentageInnerCutout : 50';
						$script[]= '}';

						// Setup Chart
						$script[]= '	var ctx' . $chart . ' = document.getElementById("' . $chart . '_area").getContext("2d");';
						$script[]= '	var myNewChart = new Chart(ctx' . $chart . ').Doughnut(data, options);';

						if ($this->eventHitsTotal) {
							echo '<script>' . implode("\n", $script) . '</script>';
						}
						?>
					<?php endforeach; ?>


				</div>
				<?php // Stats Legend ?>
				<hr>
				<div class="row px-3 pb-3">
					<div class="col-12">
						<?php foreach ($legend AS $v) : ?>
							<?php
							$ex_v = explode('@@', $v);
							$cat_title = $ex_v[0];
							$cat_color = $ex_v[1];
							?>
							<div class="d-inline-block fs-6 fw-normal text-muted">
								<div class="d-inline-block align-middle border border-1 border-secondary" style="background: <?php echo $cat_color; ?>; width: 1rem; height: 1rem; border-radius: 1rem;"></div>
								<div class="d-inline-block ms-1 me-3 align-middle"><?php echo $cat_title; ?></div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>

			<div class="card mb-3">
				<div class="card-body">
					<ul style="list-style-type: none; padding-left: 0; margin-bottom: 0;">
						<li class="mb-2">
							<a href="https://www.icagenda.com/resources/translations" target="_blank" class="my-3">
								<?php echo Text::_('COM_ICAGENDA_PANEL_TRANSLATION_PACKS_DONWLOAD');?>
							</a>
						</li>
						<?php if (ICAGENDA_VARIANT != 'core' && ICAGENDA_VARIANT) : ?>
						<li class="my-2">
							<a href="https://www.joomlic.com/support" target="_blank">
								<?php echo Text::_('COM_ICAGENDA_PANEL_PRO_TICKET_SUPPORT'); ?>
							</a>
						</li>
						<?php endif; ?>
						<li class="mt-2">
							<a href="https://forum.joomlic.com/icagenda" target="_blank" class="my-2">
								<?php echo Text::_('COM_ICAGENDA_PANEL_HELP_FORUM'); ?>
							</a>
						</li>
					</ul>
				</div>
			</div>
		</div>
	</div>

	<?php echo LayoutHelper::render('icagenda.admin.footer'); ?>
</div>
