<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-06-10
 *
 * @package     iCagenda.Admin
 * @subpackage  tmpl.info
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       2.0
 *----------------------------------------------------------------------------
*/

\defined('_JEXEC') or die;

use iCutilities\Theme\Theme as icagendaTheme;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

// Check Theme Packs Compatibility
icagendaTheme::checkThemePacks();

$translationPacks = [
	'English (United Kingdom)'   => ['en-GB', 'en.gif', 'Cyril Reze'],
	'Afrikaans (South Africa)'   => ['af-ZA', 'af.gif', 'Isileth'],
	'Arabic (Unitag)'            => ['ar-AA', 'ar.gif', 'haneen2013, fkinanah, Specialist'],
	'Basque (Spain)'             => ['eu-ES', 'eu_es.gif', 'Bizkaitarra'],
	'Bulgarian (Bulgaria)'       => ['bg-BG', 'bg.gif', 'bimbongr'],
	'Catalan (Spain)'            => ['ca-ES', 'ca.gif', 'Mussool, EduardAymerich, Figuerolero'],
	'Chinese (China)'            => ['zh-CN', 'zh.gif', 'Foxyman'],
	'Chinese (Taiwan)'           => ['zh-TW', 'tw.gif', 'jedi, hkce, rowdytang'],
	'Croatian (Croatia)'         => ['hr-HR', 'hr.gif', 'Davor Čolić (cdavor)'],
	'Czech (Czech Republic)'     => ['cz-CZ', 'cz.gif', 'Bongovo (bong)'],
	'Danish (Denmark)'           => ['dk-DK', 'dk.gif', 'olewolf.dk, torbenspetersen, hvitnov, dannikrstnsn, AhmadHamid, poulfrom'],
	'Dutch (Netherlands)'        => ['nl-NL', 'nl.gif', 'Molenwal1, AnneM, Walldorff, Mario Guagliardo, wfvdijk, robert.kleinpeter'],
	'English (United States)'    => ['en-US', 'us.gif', 'Cyril Reze'],
	'Esperanto'                  => ['eo', 'eo.gif', 'Amema, Anita_Dagmarsdotter'],
	'Estonian (Estonia)'         => ['et-EE', 'et.gif', 'Reijo, Eraser'],
	'Finnish (Finland)'          => ['fi-FI', 'fi.gif', 'Kai Metsävainio (metska)'],
	'French (France)'            => ['fr-FR', 'fr.gif', 'Cyril Reze'],
	'Galician (Spain)'           => ['gl-ES', 'gl.gif', 'XanVFR, Xnake'],
	'German (Germany)'           => ['de-DE', 'de.gif', 'grisuu, mPino, bmbsbr, Wasilis, chuerner, cordi_allemand'],
	'Greek (Greece)'             => ['el-GR', 'el.gif', 'E.Gkana-D.Kontogeorgis (elinag), kost36, rinenweb, mbini'],
	'Hungarian (Hungary)'        => ['hu-HU', 'hu.gif', 'Halilaci, magicf, Cerbo, PKH, mester93'],
	'Italian (Italy)'            => ['it-IT', 'it.gif', 'Giuseppe Bosco (giusebos)'],
	'Japanese (Japan)'           => ['ja-JP', 'ja.gif', 'nagata'],
	'Latvian (Latvia)'           => ['lv-LV', 'lv.gif', 'kredo9'],
	'Lithuanian (Lithuania)'     => ['lt-LT', 'lt.gif', 'ahxoohx'],
	'Luxembourgish (Luxembourg)' => ['lb-LU', 'icon-16-language.png', 'Superjhemp'],
	'Macedonian (Macedonia)'     => ['mk-MK', 'mk.gif', 'Strumjan (Ilija Iliev)'],
	'Norwegian Bokmål (Norway)'  => ['nb-NO', 'no.gif', 'Rikard Tømte Reitan (Rikrei)'],
	'Persian (Iran)'             => ['fa-IR', 'fa_ir.gif', 'Arash Rezvani (al3n.nvy)'],
	'Polish (Poland)'            => ['pl-PL', 'pl.gif', 'mbsrz, KISweb, gienio22, traktor, niewidzialny'],
	'Portuguese (Brazil)'        => ['pt-BR', 'pt_br.gif', 'Carosouza, alxaraujo'],
	'Portuguese (Portugal)'      => ['pt-PT', 'pt.gif', 'LFGM, macedorl, horus68'],
	'Romanian (Romania)'         => ['ro-RO', 'ro.gif', 'hat, mester93'],
	'Russian (Russia)'           => ['ru-RU', 'ru.gif', 'nshash, MSV'],
	'Serbian (latin)'            => ['sr-YU', 'sr.gif', 'Nenad Mihajlović (nenadm)'],
	'Slovak (Slovakia)'          => ['sk-SK', 'sk.gif', 'ischindl, J.Ribarszki'],
	'Slovenian (Slovenia)'       => ['sl-SI', 'sl.gif', 'erbi (Ervin Bizjak)'],
	'Spanish (Spain)'            => ['es-ES', 'es.gif', 'elerizo, mPino, albertodg, adolf64, Goncatín, claugardia, sterroso'],
	'Swedish (Sweden)'           => ['sv-SE', 'sv.gif', 'Rickard Norberg (metska), Amema, osignell, kricke'],
	'Thai (Thailand)'            => ['th-TH', 'th.gif', 'nightlight, rattanachai.ha'],
	'Turkish (Turkey)'           => ['tr-TR', 'tr.gif', 'harikalarkutusu, farukzeynep, kemalokmen'],
	'Ukrainian (Ukraine)'        => ['uk', 'uk.gif', 'Vlad Shuh (slv54)'],
];

ksort($translationPacks);
?>

<div id="container">
	<div class="row">
		<div class="col col-lg-6">
			<div class="card mb-3">
				<div class="card-header ic-card-header">
					<h2 class="text-light h3">
						<span class="icon-users text-white-50 me-1"></span> <?php echo Text::_('COM_ICAGENDA_PANEL_CONTRIBUTORS');?>
					</h2>
				</div>
				<div class="card-body">
					<figure class="text-center text-primary">
						<blockquote class="blockquote">
							<p class="fs-4">
								<span class="icon-quotes-left"></span>
								&nbsp;<?php echo Text::_('COM_ICAGENDA_PANEL_THANKS_TEXT'); ?>&nbsp;
								<span class="icon-quotes-right"></span>
							</p>
						</blockquote>
					</figure>
					<p class="fs-5">
						<b>Hall of Fame:</b> Ervin Bizjak, Bong, Giuseppe Bosco, Carosouza, Davor Čolić, doorknob, Reinhard Ekker, elirezo, jedi, jowe3, JonxDuo, KISweb, kredo9, macedorl, Kai Metsävainio, mussool, NicoDeluxe, Rickard Norberg, Andrzej Opejda, Régis, Tom-Henning, Rikard Tømte Reitan, Vlad Shuh, Leland Vandervort, Wilfred van Dijk, Roland van Wanrooy, David White ...
					</p>
				</div>
			</div>
			<div class="card mb-3">
				<div class="card-header ic-card-header">
					<h2 class="text-light h3">
						<span class="iCicon-earth text-white-50 me-1"></span> <?php echo Text::_('COM_ICAGENDA_PANEL_TRANSLATION');?>
					</h2>
				</div>
				<div class="card-body">
					<?php foreach ($translationPacks as $lang => $element) : ?>
						<?php echo '<img src="../media/mod_languages/images/' . $element[1] . '" alt="' . $element[0] . '" class="iCflag" /> &nbsp;<span class="fw-semibold">' . $lang . ':</span> ' . $element[2] . '<br />'; ?>
					<?php endforeach; ?>
				</div>
			</div>
		</div>
		<div class="col col-lg-6">
			<div class="card mb-3">
				<div class="card-body">
					<?php echo LayoutHelper::render('icagenda.admin.logo', ['version' => ICAGENDA_VARIANT]); ?>
				</div>
			</div>
			<div class="card mb-3">
				<div class="card-header ic-card-header">
					<h2 class="text-light h3">
						<span class="icon-code text-white-50 me-1"></span> Development
					</h2>
				</div>
				<div class="card-body">
					<p>
						<span class="fw-semibold"><?php echo Text::_('COM_ICAGENDA_PANEL_LEAD_DEVELOPER');?></span><br>
						Cyril Reze <small>(Lyr!C)</small><!-- | <a href="https://cyrez.dev" target="_blank">cyrez.dev</a> -->
					</p>
					<!--p>
						<span class="fw-semibold"><?php //echo Text::_('COM_ICAGENDA_PANEL_TEAM_1');?></span><br>
						Giuseppe Bosco <small>(giusebos)</small>
					</p-->
					<span class="fw-semibold"><?php echo Text::_('COM_ICAGENDA_PANEL_TEAM_CODE_CONTRIBUTORS');?></span>
					<div>
						Doorknob
						<ul>
							<small>
								<li>Features</li>
								<li>Responsive Screen Threshold Widths (media css)</li>
								<li>jQuery.highlightToday.js (module calendar)</li>
							</small>
						</ul>
					</div>
					<div>
						Tom-Henning <small>(MaW)</small>
						<ul>
							<small>
								<li>iCalcreator integration (Add to iCal/Outlook)</li>
							</small>
						</ul>
					</div>
				</div>
			</div>
			<div class="card mb-3">
				<div class="card-header ic-card-header">
					<h2 class="text-light h3">
						<span class="iCicon-iclogo text-white-50 me-1"></span> iCagenda
					</h2>
				</div>
				<div class="card-body">
					<p>
						<span class="fw-semibold"><?php echo Text::_('COM_ICAGENDA_VERSION'); ?></span><br>
						<?php echo ICAGENDA_VERSION; ?>&nbsp;<?php echo strtoupper(ICAGENDA_VARIANT); ?> <small>(<?php echo ICAGENDA_RELDATE; ?>)</small><br>
					</p>
					<p>
						<span class="fw-semibold"><?php echo Text::_('COM_ICAGENDA_COPYRIGHT');?></span><br>
						©&nbsp;2012-<?php echo date("Y"); ?> Cyril Reze / <a href="https://www.joomlic.com" target="_blank">www.joomlic.com</a>
					</p>
					<p>
						<span class="fw-semibold"><?php echo Text::_('COM_ICAGENDA_LICENSE');?></span><br>
						<a href="http://www.gnu.org/licenses/gpl.html" target="_blank">GPLv3 or later</a>
					</p>
				</div>
			</div>
			<div class="card mb-3">
				<div class="card-header ic-card-header">
					<h2 class="text-light h3">
						<span class="icon-puzzle text-white-50 me-1"></span> <?php echo Text::_('COM_ICAGENDA_LIBRARIES');?>
					</h2>
				</div>
				<div class="card-body">
					<p>
						<b>Chart.js™</b><br>
						© Chart.js Contributors | <a href="https://www.chartjs.org/" target="_blank">www.chartjs.org</a><br>
						<small>Released under the <a href="https://github.com/chartjs/Chart.js/blob/master/LICENSE.md">MIT License</a>.</small>
					</p>
					<p>
						<b>iCalcreator™</b><br>
						© Kjell-Inge Gustafsson, kigkonsult, All rights reserved | <a href="https://kigkonsult.se/iCalcreator/index.php" target="_blank">kigkonsult.se/iCalcreator</a><br>
						<small>iCalcreator is licensed under the <a href="https://github.com/iCalcreator/iCalcreator/blob/master/LICENCE">LGPLv3 License</a>.</small>
					</p>
					<p>
						<b>Google Maps™</b><br>
						© Google Inc. | <a href="https://cloud.google.com/maps-platform/terms/" target="_blank">Google Maps Platform Terms of Service</a><br>
						<small>Google™ and Google Maps™ are registered trademarks of Google Inc.</small>
					</p>
					<p>
						<b>OpenStreetMap<sup>®</sup></b><br>
						© OpenStreetMap contributors | <a href="https://www.openstreetmap.org/copyright" target="_blank">OpenStreetMap Copyright and License</a><br>
						<small>OpenStreetMap® is open data, licensed under the <a href="https://opendatacommons.org/licenses/odbl/">Open Data Commons Open Database License</a> (ODbL) by the <a href="https://osmfoundation.org/">OpenStreetMap Foundation</a> (OSMF).</small>
					</p>
					<p>
						<strong>and of course... Joomla!<sup>®</sup></strong><br />
						<a href="https://www.joomla.org" target="_blank">www.joomla.org</a>
					</p>
				</div>
			</div>
		</div>
	</div>
	<?php echo LayoutHelper::render('icagenda.admin.footer'); ?>
</div>
