<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2026-12-12
 *
 * @package     iCagenda.Site
 * @subpackage  Layouts.icagenda
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.8
 *----------------------------------------------------------------------------
 */

\defined('_JEXEC') or die;

use iCutilities\Tiptip\Tiptip as icagendaTiptip;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   string   basePath         Base path to use when loading layout files (theme pack)
 * @var   string   cancelUrl        Cancel Registration Url.
 * @var   string   customLink       Custom registration link.
 * @var   array    extraDates       List of availables dates.
 * @var   string   registered       Number of registered users.
 * @var   string   registerTarget   Register button browser target.
 * @var   string   registerUrl      Registration Url.
 * @var   string   status           Status of registration button.
 * @var   string   classButton      CSS class for button.
 * @var   string   textButton       Custom register text for button.
 * @var   string   userBooked       Logged-in user has registration(s) for this event.
 * @var   string   userRegStatus    Logged-in user has registered for this date.
*/

/*
 * Buttons HTML
 */

// Button Select Date
$selectButtonIcon = ($userRegStatus == 'registeredDate') ? 'iCicon-registered' : 'iCicon-people';
$selectButtonText = ($userRegStatus == 'registeredDate')
	? Text::_('COM_ICAGENDA_REGISTRATION_ALREADY_BOOKED')
	: Text::_('COM_ICAGENDA_REGISTRATION_DATE_NO_TICKETS_LEFT');

// Load iC Dropdown script
HTMLHelper::_('script', 'com_icagenda/iCdropdown.js', ['relative' => true, 'version' => 'auto'], ['defer' => 'defer']);

// Set the select list of available dates.
$dates_list_select = '<ul class="ic-dropdown-menu w-100 text-center" aria-labelledby="dropdownDatesListSelect">';

foreach ($extraDates as $k => $v) {
	$dates_list_select.= '<li>';
	$dates_list_select.= '<a class="ic-dropdown-item small" href="' . $k . '" rel="nofollow" target="_parent">' . $v . '</a>';
	$dates_list_select.= '</li>';
}

$dates_list_select.= '</ul>';

$btn_register_select = '<div class="btn-group-vertical ic-dropdown">';
$btn_register_select.= '<button class="' . $classButton . ' btn-info disabled mb-0" type="button">';
$btn_register_select.= '<span class="iCicon ' . $selectButtonIcon . '"></span>&nbsp;' . $selectButtonText;
$btn_register_select.= '</button>';

if ($eventDetails) {
	$btn_register_select.= '<br>';
	$btn_register_select.= '<button class="' . $classButton . ' btn-outline-info btn-sm ic-dropdown-toggle" type="button" id="dropdownDatesListSelect" aria-expanded="false">';
	$btn_register_select.= '<span class="ic-select-another-date">' . Text::_('COM_ICAGENDA_REGISTRATION_REGISTER_ANOTHER_DATE') . '</span>';
	$btn_register_select.= '</button>';
	$btn_register_select.= $dates_list_select;
}

$btn_register_select.= '</div>';

// Button Register OK
$btn_register_ok = ($deadlineDate) ? '<div class="btn-group-vertical">' : '';
$btn_register_ok.= '<button class="' . $classButton . ' btn-success" type="button" onclick="window.open(\'' . $registerUrl . '\', \'' . $registerTarget . '\')">';
$btn_register_ok.= '<span class="iCicon iCicon-register"></span>&nbsp;' . $textButton;
$btn_register_ok.= '</button>';
$btn_register_ok.= ($deadlineDate) ? '<button class="' . $classButton . ' btn-outline-success btn-sm disabled ic-opacity-1" type="button">' : '';
$btn_register_ok.= ($deadlineDate) ? '<span class="ic-register-deadline">' . Text::sprintf('COM_ICAGENDA_REGISTRATION_DEADLINE_DATE', $deadlineDate) . '</span>' : '';
$btn_register_ok.= ($deadlineDate) ? '</button>' : '';
$btn_register_ok.= ($deadlineDate) ? '</div>' : '';

// Button Register Private
$btn_register_private = '<button class="' . $classButton . ' btn-primary" type="button" onclick="window.open(\'' . $registerUrl . '\', \'' . $registerTarget . '\')">';
$btn_register_private.= '<span class="iCicon iCicon-user-lock"></span>&nbsp;' . $textButton;
$btn_register_private.= '</button>';

// Button Registration Close
$btn_register_close = '<button class="' . $classButton . ' btn-secondary disabled" type="button" disabled>';
$btn_register_close.= '<span class="iCicon iCicon-blocked"></span>&nbsp;' . Text::_('COM_ICAGENDA_REGISTRATION_CLOSED');
$btn_register_close.= '</button>';

// Button Registration Complete
$btn_register_complete = '<button class="' . $classButton . ' btn-info" type="button">';
$btn_register_complete.= '<span class="iCicon iCicon-people"></span>&nbsp;' . Text::_('COM_ICAGENDA_REGISTRATION_EVENT_FULL');
$btn_register_complete.= '</button>';

// Button Registration Already Booked
$btn_register_booked = '<button class="' . $classButton . ' btn-primary disabled" type="button" disabled>';
$btn_register_booked.= '<span class="iCicon iCicon-registered"></span>&nbsp;' . Text::_('COM_ICAGENDA_REGISTRATION_ALREADY_BOOKED');
$btn_register_booked.= '</button>';
?>

<?php echo ${'btn_register_' . $status}; ?>
