<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-11-05
 *
 * @package     iCagenda.Site
 * @subpackage  src.Controller
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.8
 *----------------------------------------------------------------------------
*/

namespace WebiC\Component\iCagenda\Site\Controller;

\defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\Input\Input;
use Joomla\CMS\Plugin\PluginHelper;

/**
 * iCagenda Component Controller
 */
class DisplayController extends \Joomla\CMS\MVC\Controller\BaseController
{
    /**
     * @param   array                 $config   An optional associative array of configuration settings.
     *                                          Recognized key values include 'name', 'default_task', 'model_path', and
     *                                          'view_path' (this list is not meant to be comprehensive).
     * @param   ?MVCFactoryInterface  $factory  The factory.
     * @param   ?CMSApplication       $app      The Application for the dispatcher
     * @param   ?Input                $input    The Input object for the request
     *
     * @since   4.0.0
     */
    public function __construct($config = [], ?MVCFactoryInterface $factory = null, $app = null, $input = null)
    {
        $this->input = Factory::getApplication()->getInput();

        // Event frontpage Editor pagebreak proxying:
//        if ($this->input->get('view') === 'manager' && $this->input->get('layout') === 'pagebreak') {
//            $config['base_path'] = JPATH_ADMINISTRATOR . '/components/com_icagenda';
//        } elseif ($this->input->get('view') === 'articles' && $this->input->get('layout') === 'modal') {
//            // Article frontpage Editor article proxying:
//            $config['base_path'] = JPATH_ADMINISTRATOR . '/components/com_content';
//        }

        parent::__construct($config, $factory, $app, $input);
    }

	/**
	 * Method to display a view.
	 *
	 * @param   boolean  $cachable   If true, the view output will be cached.
	 * @param   boolean  $urlparams  An array of safe URL parameters and their variable types, for valid values see {@link JFilterInput::clean()}.
	 *
	 * @return  \Joomla\CMS\MVC\Controller\BaseController  This object to support chaining.
	 */
	public function display($cachable = false, $urlparams = false)
	{
		// Get Application
		$app = Factory::getApplication();

		if (!PluginHelper::isEnabled('system', 'icagenda'))
		{
			$alert_message = Text::sprintf('COM_ICAGENDA_ERROR_PLUGIN_DISABLED', Text::_('COM_ICAGENDA_PLUGIN_SYSTEM_ICAGENDA'));

			$app->enqueueMessage($alert_message, 'error');

			echo Text::_('COM_ICAGENDA_ERROR_LOAD');

			return;
		}

		$cachable = true;

		/**
		 * Set the default view name and format from the Request.
		 */
		$vName = $this->input->getCmd('view', 'events');
		$this->input->set('view', $vName);

		$user = $this->app->getIdentity();

		if ($user->get('id')
			|| ($vName === 'manager')
			|| ($vName === 'registration')
			|| ($vName === 'submit')
			|| ($this->input->getMethod() === 'POST' && $vName === 'events'))
		{
			$cachable = false;
		}

		$safeurlparams = array(
			'catid'           => 'INT',
			'id'              => 'INT',
			'date'            => 'CMD',
			'page'            => 'INT',
			'year'            => 'INT',
			'month'           => 'INT',
			'return'          => 'BASE64',
			'print'           => 'BOOLEAN',
			'lang'            => 'CMD',
			'Itemid'          => 'INT',
			'filter_search'   => 'STRING',
			'filter_from'     => 'CMD',
			'filter_to'       => 'CMD',
			'filter_category' => 'INT',
			'filter_month'    => 'INT',
			'filter_year'     => 'INT',
		);

		$event_id = $this->input->getInt('event_id');

		// Check for edit form.
		if ($vName === 'manager' && $this->input->get('layout') === 'event_edit' && !$this->checkEditId('com_icagenda.edit.event', $event_id))
		{
			// Somehow the person just went to the form - we don't allow that.
			throw new \Exception(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $event_id), 403);
		}

//		if ($vName === 'manager' && \in_array($this->input->getMethod(), ['GET', 'POST'])) {
//			$model = $this->getModel($vName);
//		}
//		if ($vName === 'event')
//		{
			// Get/Create the model
//			if ($model = $this->getModel($vName))
//			{
//				if (ComponentHelper::getParams('com_icagenda')->get('record_hits', 1) == 1)
//				{
//					$model->hit();
//				}
//			}
//		}

		// Load translations
		$language = Factory::getLanguage();
		$language->load('com_icagenda', JPATH_SITE, 'en-GB', true);
		$language->load('com_icagenda', JPATH_SITE, null, true);

		// Load Vector iCicons Font
		HTMLHelper::_('stylesheet', 'media/com_icagenda/icicons/style.css');

		// Shared CSS
		HTMLHelper::_('stylesheet', 'com_icagenda/icagenda.css', array('relative' => true, 'version' => 'auto'));

		// CSS files which could be overridden into the site template. (eg. /templates/my_template/css/com_icagenda/icagenda-front.css)
		HTMLHelper::_('stylesheet', 'com_icagenda/icagenda-front.css', array('relative' => true, 'version' => 'auto'));

		// Check iCagenda System Errors
		$systemReady = $app->triggerEvent('onICagendaSystemCheck');

		if (\is_array($systemReady) && \count($systemReady) > 0 && \in_array(false, $systemReady, true))
		{
			echo Text::_('COM_ICAGENDA_ERROR_LOAD');

			return;
		}

		parent::display($cachable, $safeurlparams);

		return $this;
	}
}
