<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *              Module iCagenda Calendar
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-08-30
 *
 * @package     iCagenda.Site
 * @subpackage  mod_icagenda_calendar
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       4.0.0
 *----------------------------------------------------------------------------
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\Service\Provider\HelperFactory;
use Joomla\CMS\Extension\Service\Provider\Module;
use Joomla\CMS\Extension\Service\Provider\ModuleDispatcherFactory;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

/**
 * The iCagenda Calendar module service provider.
 */
return new class () implements ServiceProviderInterface {
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     */
    public function register(Container $container)
    {
        $container->registerServiceProvider(new ModuleDispatcherFactory('\\WebiC\\Module\\IcagendaCalendar'));
        $container->registerServiceProvider(new HelperFactory('\\WebiC\\Module\\IcagendaCalendar\\Site\\Helper'));

        $container->registerServiceProvider(new Module());
    }
};
