<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.8.5 2022-04-29
 *
 * @package     iCagenda.Site
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2024 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.6.0
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidator');
JHtml::_('formbehavior.chosen', '#icagenda-registration select');

// Get the core Joomla objects
$app      = JFactory::getApplication();
$document = JFactory::getDocument();

// Disable submit button after first click (TODO : check and simplify)
$document->addScriptDeclaration('
	jQuery(function($) {
		$("#icagenda-registration").one("submit", function() {
			$(this).find(\'button[type="submit"]\')
				.attr("disabled","disabled")
				.css({
					"background-color": "transparent",
					"color": "grey"
				});
			$("#submit").addClass("ic-loader");
			$(".buttonx").css("display", "none");
		});
	});
');

// Create shortcuts to some parameters.
$item = $this->item;

// Form Validation (Only Server side validation (1), or Client & Server validation (default))
$form_validate = ($this->reg_form_validation == 1) ? '' : ' form-validate';
$novalidate    = ($this->reg_form_validation == 1) ? ' novalidate' : '';

// Load custom fields
$customFields = icagendaCustomfields::getCustomFields(1, $item->params->get('custom_form', ''));
$listSlugs    = icagendaCustomfields::listSlugs($customFields);
?>

<?php // START CONTENT ?>
<div id="icagenda" class="ic-registration-view<?php echo $this->pageclass_sfx; ?>">

	<?php echo "<!-- " . $this->template . " -->"; ?>

	<?php // iCagenda Vars ?>
	<?php require_once $this->icevent_vars; ?>

	<?php // Content is generated by icagenda plugin event "onICagendaRegistrationBeforeDisplay" ?>
	<?php echo $item->pluginEvent->beforeDisplayRegistration; ?>

	<?php // Theme Pack layout (Header) ?>
	<?php require_once $this->themeRegistration; ?>

	<?php // TITLE REGISTRATION ?>
	<div class="ic-form-title">
		<h1><?php echo JText::_('COM_ICAGENDA_REGISTRATION_TITLE'); ?></h1>
	</div>

	<?php // FIELDS REQUIRED INFO ?>
	<div class="ic-required-info">
		<?php echo JText::_('COM_ICAGENDA_FORM_REQUIRED_INFO'); ?>
	</div>

	<?php // START FORM ?>
	<form class="form-horizontal well<?php echo $form_validate; ?>"
		id="icagenda-registration"
		action="<?php echo JRoute::_('index.php?option=com_icagenda&task=registration.register'); ?>"
		method="post"
		enctype="multipart/form-data"<?php echo $novalidate; ?>
		>

		<fieldset>

			<legend><?php echo JText::_('COM_ICAGENDA_REGISTRATION_YOUR_INFORMATION_LEGEND'); ?></legend>

			<?php // CORE FIELDS (fieldset 'default') ?>
			<?php $fields = $this->form->getFieldset('default'); ?>
			<?php foreach ($fields as $field) : ?>
				<?php if (isset($this->coreFields[$field->fieldname]) && $this->coreFields[$field->fieldname] && ! in_array('core_' . $field->fieldname, $listSlugs)) : ?>
					<?php $emptyDesc = 'COM_ICAGENDA_REGISTRATION_' . strtoupper(str_replace('note_', '' , $field->fieldname)) . '_DESC'; ?>
					<?php if ($this->params->get('form_field_description')) : ?>
						<?php if ($field->type == 'Note' && JText::_($field->description) == $emptyDesc) : ?>
							<?php // Do not display. ?>
						<?php else : ?>
							<?php $field->description = ''; ?>
							<?php $document->addStyleDeclaration('#jform_' . $field->fieldname . '-lbl { cursor: auto; }'); ?>
							<?php echo $field->renderField(); ?>
						<?php endif; ?>
					<?php elseif ($field->type != 'Note') : ?>
						<?php if (JText::_($field->description) == $emptyDesc) : ?>
							<?php $field->description = ''; ?>
							<?php $document->addStyleDeclaration('#jform_' . $field->fieldname . '-lbl { cursor: auto; }'); ?>
						<?php endif; ?>
						<?php echo $field->renderField(); ?>
					<?php endif; ?>
				<?php endif; ?>
			<?php endforeach; ?>

			<?php // CUSTOM FIELDS ?>
			<?php $customFieldsLoader = icagendaCustomfields::loader(1, $item->params->get('custom_form', '')); ?>
			<?php if ($customFieldsLoader) : ?>
				<?php $customfields = $this->form->getFieldset('customfields'); ?>
				<?php foreach ($customfields as $field) : ?>
					<?php echo $field->renderField(); ?>
				<?php endforeach; ?>
				<?php echo $customFieldsLoader; ?>

			<?php endif; ?>

			<?php // TEMPORARY FIELDS (fieldset 'temporary', to be migrated to core/override) ?>
			<?php $fields = $this->form->getFieldset('temporary'); ?>
			<?php if (\count($fields)) : ?>
				<?php // Iterate through the fields in the set and display them. ?>
				<?php foreach ($fields as $field) : ?>
					<?php if (isset($this->extraFields[$field->fieldname]) && $this->extraFields[$field->fieldname]) : ?>
						<?php // If the field is hidden, just display the input. ?>
						<?php if ($field->hidden) : ?>
							<?php echo $this->form->getInput($field->fieldname); ?>
						<?php else : ?>
							<?php echo $field->renderField(); ?>
						<?php endif; ?>
					<?php endif; ?>
				<?php endforeach; ?>
			<?php endif; ?>

		</fieldset>

		<?php // CONSENT : PRIVACY / TERMS & CONDITIONS ?>
		<?php foreach ($this->form->getFieldsets('consent') as $fieldset) : ?>
			<fieldset>
				<?php if (\count($this->form->getFieldset($fieldset->name))) : ?>
					<?php if (isset($fieldset->label)) : ?>
						<legend><?php echo JText::_($fieldset->label); ?></legend>
						<br />
					<?php endif; ?>
				<?php endif; ?>
				<?php echo $this->form->renderFieldset($fieldset->name); ?>
			</fieldset>
		<?php endforeach; ?>

		<?php // EXTRA FIELDS (fieldset 'extra') ?>
		<?php $fields = $this->form->getFieldset('extra'); ?>
		<?php if (\count($fields)) : ?>
			<fieldset>
			<?php // Iterate through the fields in the set and display them. ?>
			<?php foreach ($fields as $field) : ?>
				<?php if (isset($this->extraFields[$field->fieldname]) && $this->extraFields[$field->fieldname]) : ?>
					<?php // If the field is hidden, just display the input. ?>
					<?php if ($field->hidden) : ?>
						<?php echo $this->form->getInput($field->fieldname); ?>
					<?php else : ?>
						<?php echo $field->renderField(); ?>
					<?php endif; ?>
				<?php endif; ?>
			<?php endforeach; ?>
			</fieldset>
		<?php endif; ?>

		<?php // HIDDEN FIELDS (fieldset 'hidden') ?>
		<?php $eventid = $app->input->getInt('id'); ?>
		<?php $menuid  = $app->input->getInt('Itemid'); ?>
		<?php $fields  = $this->form->getFieldset('hidden'); ?>
		<?php if (\count($fields)) : ?>
			<fieldset>
			<?php // Iterate through the fields in the set and display them. ?>
			<?php foreach ($fields as $field) : ?>
				<?php if ($field->hidden) : ?>
					<?php echo $this->form->getInput($field->fieldname, null, ${$field->fieldname}); ?>
				<?php endif; ?>
			<?php endforeach; ?>
			</fieldset>
		<?php endif; ?>

		<?php // Input to process registration function, not saved in database ?>
		<input name="jform[type_registration]" type="hidden" value="<?php echo $item->params->get('typeReg', '1'); ?>" />
		<input name="jform[max_nb_of_tickets]" type="hidden" value="<?php echo $item->params->get('maxReg', '1000000'); ?>" />

		<?php
		if ($this->registrationActions
			&& $item->params->get('registration_actions', 0))
		{
			$registerButton = JText::_('COM_ICAGENDA_REGISTRATION_ACTIONS_NEXT');
		}
		else
		{
			$registerButton = JText::_('COM_ICAGENDA_REGISTRATION_REGISTER_BTN');
			$registerButton = ($registerButton == 'Register') ? JText::_('JREGISTER') : $registerButton; // B/C before 3.6.13
		}
		?>

		<?php // Form Submit or Cancel ?>
		<div class="control-group" id="submit">
			<div class="controls">
				<button class="btn btn-primary validate" type="submit"><?php echo $registerButton; ?></button>
				<input name="eventID" type="hidden" value="<?php echo $app->input->getInt('id'); ?>" />
				<input name="option" type="hidden" value="com_icagenda" />
				<input name="task" type="hidden" value="registration.register" />
				<?php echo JHtml::_('form.token'); ?>
				<a class="btn" href="<?php echo $this->eventURL; ?>" title="<?php echo JTEXT::_('COM_ICAGENDA_CANCEL'); ?>">
					<?php echo JTEXT::_('COM_ICAGENDA_CANCEL'); ?>
				</a>
			</div>
		</div>
	</form>

	<?php // Content is generated by icagenda plugin event "onICagendaRegistrationAfterDisplay" ?>
	<?php echo $item->pluginEvent->afterDisplayRegistration; ?>
</div>
