<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.8.17 2023-05-19
 *
 * @package     iCagenda.Site
 * @subpackage  tmpl.event
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2024 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.6
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

// Shortcut for item
$item = $this->item;

// Check if cancelled, to add ic-event-cancelled class if true
$isCancelled = $item->params->get('event_cancelled', 0) ? ' ic-event-cancelled' : '';
?>

<div id="icagenda" class="ic-event-view<?php echo $this->pageclass_sfx . $isCancelled; ?>">

	<?php // Top Buttons ?>
	<?php echo $this->loadTemplate('top'); ?>

	<?php echo "<!-- " . $this->template . " -->"; ?>

	<?php // Content is generated by content plugin event "iCagendaOnEventBeforeDisplay" ?>
	<?php echo $item->event->iCagendaOnEventBeforeDisplay; ?>

	<?php // iCagenda Vars ?>
	<?php require_once $this->eventShortcuts; ?>

	<?php // Layout for Event Details view (from Theme Pack) ?>
	<?php require_once $this->themeEvent; ?>

	<?php // Content is generated by content plugin event "iCagendaOnEventAfterDisplay" ?>
	<?php echo $item->event->iCagendaOnEventAfterDisplay; ?>
</div>
