<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.6.9 2017-07-04
 *
 * @package     iCagenda.Admin
 * @subpackage  Assets.Elements
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       1.2.3
 *----------------------------------------------------------------------------
*/

// No direct access to this file
defined('JPATH_BASE') or die;

jimport('joomla.form.formfield');

// Test if translation is missing, set to en-GB by default
$language = JFactory::getLanguage();
$language->load('com_icagenda', JPATH_ADMINISTRATOR, 'en-GB', true);
$language->load('com_icagenda', JPATH_ADMINISTRATOR, null, true);

JHtml::stylesheet('com_icagenda/icagenda-back.css', false, true);


class JFormFieldTitle extends JFormField
{
	protected $type = 'Title';

	protected function getLabel()
	{
		return ' ';
	}

	protected function getInput()
	{
		$html = array();

		$document = JFactory::getDocument();
		$document->addStyleSheet( JURI::root( true ) . '/media/com_icagenda/icicons/style.css' );

		// Joomla 2.5
		if (version_compare(JVERSION, '3.0', 'lt'))
		{
			JHtml::stylesheet('com_icagenda/template.j25.css', false, true);
			JHtml::stylesheet('com_icagenda/icagenda-back.j25.css', false, true);

			JHTML::_('behavior.framework');

			// load jQuery, if not loaded before
			$scripts = array_keys($document->_scripts);
			$scriptFound = false;
			$scriptuiFound = false;

			for ($i = 0; $i < count($scripts); $i++)
			{
				if (stripos($scripts[$i], 'jquery.min.js') !== false)
				{
					$scriptFound = true;
				}
				// load jQuery, if not loaded before as jquery
				if (stripos($scripts[$i], 'jquery.js') !== false)
				{
					$scriptFound = true;
				}
				if (stripos($scripts[$i], 'jquery-ui.min.js') !== false)
				{
					$scriptuiFound = true;
				}
			}

			// jQuery Library Loader
			if (!$scriptFound)
			{
				// load jQuery, if not loaded before
				if (!JFactory::getApplication()->get('jquery'))
				{
					JFactory::getApplication()->set('jquery', true);
					// add jQuery
					$document->addScript('https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js');
					$document->addScript( JURI::root( true ) . '/media/com_icagenda/js/jquery.noconflict.js' );
				}
			}

			if (!$scriptuiFound)
			{
				$document->addScript('https://ajax.googleapis.com/ajax/libs/jqueryui/1.9.2/jquery-ui.min.js');
			}

			$document->addScript( JURI::root( true ) . '/media/com_icagenda/js/template.js' );
		}

    	$label = $this->element['label'];
		$label = $this->translateLabel ? JText::_($label) : $label;

    	$style = $this->element['style'];
		$style = $this->translateLabel ? JText::_($style) : $style;

    	$class = $this->element['class'];
		$class = $this->translateLabel ? JText::_($class) : $class;


		// Contruction
    	$html[] = "<div class='";
    	$html[] = $class;
    	$html[] = " element-title' ";
    	$html[] = "style='";
    	$html[] = $style;
    	$html[] = "'>";
    	$html[] = $label;
    	$html[] = "</div>";

    	return implode('',$html);
	}
}
