<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.8.6 2022-05-12
 *
 * @package     iCagenda.Site
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.2
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidator');
JHtml::_('formbehavior.chosen', '#icagenda-submit select');

JHtml::_('script', 'com_icagenda/icform.js', array('relative' => true, 'version' => 'auto'), array('async' => 'async'));

JHtml::_('stylesheet', 'com_icagenda/icagenda.css', array('relative' => true, 'version' => 'auto'));

// JFactory
$app      = JFactory::getapplication();
$document = JFactory::getDocument();

$document->addScriptDeclaration('
	var limitSize = "' . $this->params->get('submit_imageMaxSize', '800') . '";
');

// Create shortcuts to some parameters.
$maps_service = $this->params->get('maps_service', 1);

// Form Validation
if ($this->submit_form_validation == 1)
{
	$novalidate    = ' novalidate';
	$form_validate = '';
	$iCheckForm    = '';
}
else
{
	$novalidate    = '';
	$form_validate = ' form-validate';
	$iCheckForm    = '';
//	$iCheckForm    = ' onclick="iCheckForm();"';

	// Script validation for Submit Event form (2)
//	$formScript = icagendaForm::submit(2);
//	JFactory::getDocument()->addScriptDeclaration($formScript);

//	// Needs globalization for rendered format...
//	JFactory::getDocument()->addScriptDeclaration("
//		jQuery(document).ready(function(){
//			document.formvalidator.setHandler('date', function(value) {
//				regex=/^\d{4}-\d{2}-\d{2}\ \d{2}:\d{2}$/;
//				return regex.test(value);
//			});
//		});

//		function strpos (haystack, needle, offset) {
//			var i = (haystack + '').indexOf(needle, (offset || 0));
//			return i === -1 ? false : i;
//		}

//			var nodate = '0';
//			var noserialdate = 'a:1:{i:0;s:19:\"0000-00-00 00:00:00\";}';
//			var noserialdate2 = 'a:1:{i:0;s:16:\"0000-00-00 00:00\";}';
//			var emptydatetime = '0000-00-00 00:00:00';

//			var startDate = document.getElementById('jform_startdate');
//			var endDate = document.getElementById('jform_enddate');
//			var Dates = document.getElementById('jform_dates');
//			var isValidStartDate = (startDate == '');
//			var isValidEndDate = strpos(endDate.value, nodate, 0);
//			var isValidSingleDate = strpos(Dates.value, nodate, 2);

//			if (endDate.value && !isValidEndDate)
//			{
//				alert(endDate.value);
//			}
//	");

	$document->addScriptDeclaration("
		function iCheckForm()
		{
			if (!document.formvalidator.isValid(document.getElementById('icagenda-submit')))
			{
				contentTop = document.getElementById('content');
				contentTop.scrollIntoView();
			}
		}
	");
}
?>

<div id="icagenda" class="ic-submit-view<?php echo $this->pageclass_sfx; ?>">

	<?php // Content is generated by content plugin event "iCagendaOnSubmitBeforeDisplay" ?>
	<?php echo $this->pluginEvent->iCagendaOnSubmitBeforeDisplay; ?>

	<?php // PAGE HEADING ?>
	<?php if ($this->params->get('show_page_heading', 1)) : ?>
	<div class="page-header">
		<h1> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
	</div>
	<?php endif; ?>

	<?php // FIELDS REQUIRED INFO ?>
	<div class="ic-required-info">
		<?php echo JText::_('COM_ICAGENDA_FORM_REQUIRED_INFO'); ?>
	</div>

	<?php // START FORM ?>
	<form class="form-horizontal well<?php echo $form_validate; ?>"
		id="icagenda-submit"
		action="<?php echo JRoute::_('index.php?option=com_icagenda&task=submit.submit'); ?>"
		method="post"
		enctype="multipart/form-data"<?php echo $novalidate; ?>
		>

		<?php // User Information ?>
		<?php $fields = $this->form->getFieldset('user'); ?>
		<?php if (count($fields)) : ?>
			<fieldset>

				<legend><?php echo JText::_('COM_ICAGENDA_LEGEND_USERINFOS'); ?></legend>

				<?php foreach ($fields as $field) : ?>
					<?php $emptyDesc = 'COM_ICAGENDA_SUBMIT_' . strtoupper(str_replace('note_', '' , $field->fieldname)) . '_DESC'; ?>
					<?php if ($this->params->get('form_field_description')) : ?>
						<?php if ($field->type == 'Note' && JText::_($field->description) == $emptyDesc) : ?>
							<?php // Do not display. ?>
						<?php else : ?>
							<?php $field->description = ''; ?>
							<?php $document->addStyleDeclaration('#jform_' . $field->fieldname . '-lbl { cursor: auto; }'); ?>
							<?php echo $field->renderField(); ?>
						<?php endif; ?>
					<?php elseif ($field->type != 'Note') : ?>
						<?php if (JText::_($field->description) == $emptyDesc) : ?>
							<?php $field->description = ''; ?>
							<?php $document->addStyleDeclaration('#jform_' . $field->fieldname . '-lbl { cursor: auto; }'); ?>
						<?php endif; ?>
						<?php echo $field->renderField(); ?>
					<?php endif; ?>
				<?php endforeach; ?>

			</fieldset>
			<hr />
		<?php endif; ?>

		<?php // Event Info ?>
		<?php $fields = $this->form->getFieldset('event'); ?>
		<?php if (count($fields)) : ?>
			<fieldset>

				<legend><?php echo JText::_('COM_ICAGENDA_LEGEND_NEW_EVENT'); ?></legend>

				<?php foreach ($fields as $field) : ?>
					<?php $emptyDesc = 'COM_ICAGENDA_SUBMIT_' . strtoupper(str_replace('note_', '' , $field->fieldname)) . '_DESC'; ?>
					<?php if ($this->params->get('form_field_description')) : ?>
						<?php if ($field->type == 'Note' && JText::_($field->description) == $emptyDesc) : ?>
							<?php // Do not display. ?>
						<?php else : ?>
							<?php $field->description = ''; ?>
							<?php $document->addStyleDeclaration('#jform_' . $field->fieldname . '-lbl { cursor: auto; }'); ?>
							<?php echo $field->renderField(); ?>
						<?php endif; ?>
					<?php elseif ($field->type != 'Note') : ?>
						<?php if (JText::_($field->description) == $emptyDesc) : ?>
							<?php $field->description = ''; ?>
							<?php $document->addStyleDeclaration('#jform_' . $field->fieldname . '-lbl { cursor: auto; }'); ?>
						<?php endif; ?>
						<?php echo $field->renderField(); ?>
					<?php endif; ?>
				<?php endforeach; ?>

			</fieldset>
			<hr />
		<?php endif; ?>

		<?php // Event Dates ?>
		<?php $fields = $this->form->getFieldset('dates'); ?>
		<?php if (count($fields)) : ?>
			<fieldset>

				<legend><?php echo JText::_('COM_ICAGENDA_LEGEND_DATES'); ?></legend>

				<?php foreach ($fields as $field) : ?>
					<?php $emptyDesc = 'COM_ICAGENDA_SUBMIT_' . strtoupper(str_replace('note_', '' , $field->fieldname)) . '_DESC'; ?>
					<?php if ($this->params->get('form_field_description')) : ?>
						<?php if ($field->type == 'Note' && JText::_($field->description) == $emptyDesc) : ?>
							<?php // Do not display. ?>
						<?php else : ?>
							<?php $field->description = ''; ?>
							<?php echo ($field->fieldname == 'dates') ? $field->input : $field->renderField(); ?>
						<?php endif; ?>
					<?php else : ?>
						<?php if ($field->type == 'Note' && $field->description == '') : ?>
							<?php echo $field->renderField(); ?>
						<?php elseif ($field->type != 'Note') : ?>
							<?php if (JText::_($field->description) == $emptyDesc) : ?>
								<?php $field->description = ''; ?>
							<?php endif; ?>
							<?php echo ($field->fieldname == 'dates') ? $field->input : $field->renderField(); ?>
						<?php endif; ?>
					<?php endif; ?>
					<?php if ( ! $field->description && $field->type != 'Note') : ?>
						<?php $document->addStyleDeclaration('#jform_' . $field->fieldname . '-lbl { cursor: auto; }'); ?>
					<?php endif; ?>
				<?php endforeach; ?>

			</fieldset>
			<hr />
		<?php endif; ?>

		<?php // Event Description ?>
		<?php $fields = $this->form->getFieldset('description'); ?>
		<?php if (count($fields)) : ?>
			<fieldset>

				<legend><?php echo JText::_('COM_ICAGENDA_SUBMIT_DESCRIPTION_LEGEND'); ?></legend>

				<?php foreach ($fields as $field) : ?>
					<?php $emptyDesc = 'COM_ICAGENDA_SUBMIT_' . strtoupper(str_replace('_title', '' , $field->fieldname)) . '_DESC'; ?>
					<?php if (JText::_($field->description) == $emptyDesc) : ?>
						<?php $this->form->setFieldAttribute($field->fieldname, 'description', ''); ?>
					<?php endif; ?>
					<?php if ($field->title != '') : ?>
						<?php echo $field->renderField(); ?>
					<?php else : ?>
						<?php echo $field->input; ?>
					<?php endif; ?>
				<?php endforeach; ?>

			</fieldset>
			<hr />
		<?php endif; ?>

		<?php // Event Information & Custom Fields ?>
		<?php $fields = $this->form->getFieldset('information'); ?>
		<?php $customFieldsLoader = icagendaCustomfields::loader(2); ?>
		<?php if (count($fields) || ($customFieldsLoader && $this->params->get('submit_customfieldsDisplay', 1))) : ?>
			<fieldset>

				<legend><?php echo JText::_('COM_ICAGENDA_LEGEND_INFORMATION'); ?></legend>

				<?php // Load Information Fields ?>
				<?php if (count($fields)) : ?>
					<?php foreach ($fields as $field) : ?>
						<?php $emptyDesc = 'COM_ICAGENDA_SUBMIT_' . strtoupper(str_replace('note_', '' , $field->fieldname)) . '_DESC'; ?>
						<?php if ($this->params->get('form_field_description')) : ?>
							<?php if ($field->type == 'Note' && JText::_($field->description) == $emptyDesc) : ?>
								<?php // Do not display. ?>
							<?php else : ?>
								<?php $field->description = ''; ?>
								<?php $document->addStyleDeclaration('#jform_' . $field->fieldname . '-lbl { cursor: auto; }'); ?>
								<?php echo $field->renderField(); ?>
							<?php endif; ?>
						<?php elseif ($field->type != 'Note' || ($field->type == 'Note' && $field->description == '')) : ?>
							<?php if (JText::_($field->description) == $emptyDesc) : ?>
								<?php $field->description = ''; ?>
								<?php $document->addStyleDeclaration('#jform_' . $field->fieldname . '-lbl { cursor: auto; }'); ?>
							<?php endif; ?>
							<?php echo $field->renderField(); ?>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>

				<?php // Load Custom fields - Event form (2) ?>
				<?php if ($customFieldsLoader && $this->params->get('submit_customfieldsDisplay', 1)) : ?>
					<?php $customfields = $this->form->getFieldset('customfields'); ?>
					<?php foreach ($customfields as $field) : ?>
						<?php echo $field->renderField(); ?>
					<?php endforeach; ?>
					<?php echo $customFieldsLoader; ?>
				<?php endif; ?>

			</fieldset>
			<hr />
		<?php endif; ?>

		<?php // Maps Field Set ?>
		<?php if ($this->params->get('submit_gmapDisplay', 1)) : ?>
			<?php if ($this->params->get('form_field_description')
				&& JText::_($this->form->getField('note_address')->description) !== 'COM_ICAGENDA_SUBMIT_ADDRESS_DESC') : ?>
				<?php $this->form->setFieldAttribute('address', 'description', ''); ?>
				<?php $document->addStyleDeclaration('#jform_address-lbl { cursor: default; }'); ?>
				<?php $note_address = $this->form->renderField('note_address'); ?>
			<?php else : ?>
				<?php $note_address = ''; ?>
			<?php endif; ?>
			<fieldset>

				<legend><?php echo JText::_('COM_ICAGENDA_EVENT_MAP_LEGEND'); ?></legend>

				<div class="fieldset">
					<div id="icagenda-map">
						<div class="row-fluid">
							<?php if ( ! $maps_service) : ?>
							<div class="span12">
								<div class="icmap-address">
									<div class="control-group">
										<div class="control-label">
											<?php echo $this->form->getLabel('address'); ?>
										</div>
										<div class="controls">
											<?php echo $this->form->getInput('address'); ?>
										</div>
									</div>
								</div>
								<?php echo JText::_('COM_ICAGENDA_MAPS_SERVICE_NOT_AVAILABLE'); ?>
							</div>

							<!-- LeafLet OpenStreetMap -->
							<?php elseif ($maps_service == '1') : ?>
							<div class="span12">
								<div class="icmap-address">
									<div class="control-group">
										<div class="control-label">
											<?php echo $this->form->getLabel('address'); ?>
										</div>
										<div class="controls">
											<div id="findbox"></div>
											<?php echo $this->form->getInput('address'); ?>
										</div>
									</div>
									<?php echo $note_address; ?>
								</div>
							</div>
							<div>
								<div class="span3">
									<div class="icmap-field">
										<?php echo $this->form->getInput('city'); ?>
									</div>
									<div class="icmap-field">
										<?php echo $this->form->getInput('country'); ?>
									</div>
									<div class="icmap-field">
										<?php echo $this->form->getInput('lat'); ?>
									</div>
									<div class="icmap-field">
										<?php echo $this->form->getInput('lng'); ?>
									</div>
								</div>
								<div class="span9">
									<div class="ic-map-container">
										<div class="ic-map-wrapper" id="ic-map-0"></div>
									</div>
								</div>
							</div>
							<?php icagendaMapsLeafletSearch::addJS('ic-map-0', 'jform_address'); ?>

							<!-- Google Maps Embed API -->
							<?php elseif ($maps_service == '2') : ?>
							<div class="span12">
								<div class="icmap-address">
									<div class="control-group">
										<div class="control-label">
											<?php echo $this->form->getLabel('address'); ?>
										</div>
										<div class="controls">
											<div class="input-append">
												<?php echo $this->form->getInput('address'); ?>
												<span class="btn btn-default" onclick="checkGoogleMap(document.getElementById('jform_address').value)"><?php echo JText::_('IC_CHECK'); ?></span>
											</div>
										</div>
									</div>
									<?php echo $note_address; ?>
								</div>
								<div class="ic-map-container">
									<div id="embed_map" class="ic-map-wrapper"></div>
								</div>
								<?php
									$apiKey = $this->params->get('googlemaps_embed_key', '');
								?>
								<?php icagendaMapsGoogleSearch::addEmbedJS('embed_map', 'jform_address', array('apiKey' => $apiKey)); ?>
							</div>

							<!-- Google Maps Javascript API -->
							<?php elseif ($maps_service == '3') : ?>
							<div class="span6 ic-align-left">
								<h3><?php echo JText::_('COM_ICAGENDA_GOOGLE_MAPS_SUBTITLE_LBL'); ?></h3>
								<div>
									<?php echo JText::_('COM_ICAGENDA_GOOGLE_MAPS_NOTE1'); ?>
									<br/>
									<?php echo JText::_('COM_ICAGENDA_GOOGLE_MAPS_NOTE2'); ?>
									<br/>
								</div>
								<div style="clear:both"></div>
								<div>
									<div class="icmap-address">
										<div class="icmap-label">
											<?php echo $this->form->getLabel('address'); ?>
										</div>
										<?php echo $this->form->getInput('address'); ?>
									</div>
									<div class="icmap-field">
										<?php echo $this->form->getInput('city'); ?>
									</div>
									<div class="icmap-field">
										<?php echo $this->form->getInput('country'); ?>
									</div>
									<div class="icmap-field">
										<?php echo $this->form->getInput('lat'); ?>
									</div>
									<div class="icmap-field">
										<?php echo $this->form->getInput('lng'); ?>
									</div>
								</div>
							</div>
							<div class="span6 ic-align-left">
								<div class="ic-map-container">
									<h3><?php echo JText::_('COM_ICAGENDA_EVENT_MAP_LEGEND'); ?></h3>
									<label id="geo_label" for="reverseGeocode"><?php echo JText::_('COM_ICAGENDA_GOOGLE_MAPS_REVERSE'); ?></label>
									<select id="reverseGeocode">
										<option value="false" selected><?php echo JText::_('JNO'); ?></option>
										<option value="true"><?php echo JText::_('JYES'); ?></option>
									</select><br />
									<div id="map" class="ic-map-wrapper"></div>
									<div id="legend" class="ic-map-legend"><?php echo JText::_('COM_ICAGENDA_GOOGLE_MAPS_LEGEND'); ?></div>
								</div>
								<?php
									$apiKey    = $this->params->get('googlemaps_browser_key', '');
									$apiClient = $this->params->get('googlemaps_client_id', '');
								?>
								<?php icagendaMapsGoogleSearch::addJS('map', 'jform_address', array('apiKey' => $apiKey, 'apiClient' => $apiClient)); ?>
							</div>
						<?php endif; ?>
						</div>
					</div>
				</div>
				<div>&nbsp;</div>

			</fieldset>
			<hr />
		<?php endif; ?>

		<?php // Registration option ?>
		<?php $fields = $this->form->getFieldset('registration'); ?>
		<?php if (count($fields) && $this->params->get('submit_regoptionsDisplay', 1)) : ?>
			<fieldset>

				<legend><?php echo JText::_('COM_ICAGENDA_REGISTRATION_OPTIONS'); ?></legend>

				<?php foreach ($fields as $field) : ?>
					<?php $emptyDesc = 'COM_ICAGENDA_SUBMIT_' . strtoupper(str_replace('note_', '' , $field->fieldname)) . '_DESC'; ?>
					<?php if ($this->params->get('form_field_description')) : ?>
						<?php if ($field->type == 'Note' && JText::_($field->description) == $emptyDesc) : ?>
							<?php // Do not display. ?>
						<?php else : ?>
							<?php $field->description = ''; ?>
							<?php $document->addStyleDeclaration('#jform_' . $field->fieldname . '-lbl { cursor: auto; }'); ?>
							<?php echo $field->renderField(); ?>
						<?php endif; ?>
					<?php elseif ($field->type != 'Note') : ?>
						<?php if (JText::_($field->description) == $emptyDesc) : ?>
							<?php $field->description = ''; ?>
							<?php $document->addStyleDeclaration('#jform_' . $field->fieldname . '-lbl { cursor: auto; }'); ?>
						<?php endif; ?>
						<?php echo $field->renderField(); ?>
					<?php endif; ?>
				<?php endforeach; ?>

			</fieldset>
			<hr />
		<?php endif; ?>

		<?php // Terms & Conditions ?>
		<?php if ($this->params->get('tos', 1)) : ?>
			<legend><?php echo JText::_('COM_ICAGENDA_SUBMIT_CONSENT_TOS_LABEL'); ?></legend>
			<br />
			<?php echo $this->form->renderField('consent_tos', 'consent'); ?>
		<?php endif; ?>

		<?php // Extra Fields ?>
		<?php $fields = $this->form->getFieldset('extra'); ?>
		<?php if (count($fields)) : ?>
			<?php foreach ($fields as $field) : ?>
				<?php echo $field->renderField(); ?>
			<?php endforeach; ?>
		<?php endif; ?>

		<?php // Hidden Fields ?>
		<?php $fields = $this->form->getFieldset('hidden'); ?>
		<?php if (count($fields)) : ?>
			<?php foreach ($fields as $field) : ?>
				<?php if ($field->fieldname == 'itemid') : ?>
					<?php $this->form->setValue('itemid', null, $app->getMenu()->getActive()->id); ?>
				<?php elseif ($field->fieldname == 'itemid_title') : ?>
					<?php $this->form->setValue('itemid_title', null, $app->getMenu()->getActive()->title); ?>
				<?php endif; ?>
				<?php echo $this->form->getInput($field->fieldname); ?>
			<?php endforeach; ?>
		<?php endif; ?>

		<?php // Form Submit or Cancel ?>
		<div class="control-group" id="submit">
			<div class="controls">
				<button class="btn btn-primary validate" type="submit"<?php echo $iCheckForm; ?>>
					<?php echo JText::_('COM_ICAGENDA_EVENT_FORM_SUBMIT'); ?>
				</button>
				<input name="option" type="hidden" value="com_icagenda" />
				<input name="task" type="hidden" value="submit.submit" />
				<?php echo JHtml::_('form.token'); ?>
			</div>
		</div>
	</form>

	<?php // Content is generated by icagenda plugin event "iCagendaOnSubmitAfterDisplay" ?>
	<?php echo $this->pluginEvent->iCagendaOnSubmitAfterDisplay; ?>
</div>
