<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *              Module iCagenda Calendar
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-11-16
 *
 * @package     iCagenda.Site
 * @subpackage  mod_icagenda_calendar
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       4.0.0
 *----------------------------------------------------------------------------
 */

\defined('_JEXEC') or die;

use WebiC\Module\IcagendaCalendar\Site\Helper\IcagendaCalendarHelper;
use Joomla\CMS\Factory;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$app = Factory::getApplication();
$wa = $app->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('mod_icagenda_calendar');
$wa->usePreset('mod_icagenda_calendar.calendar');

$headerText = $params->get('header_text', '');
$footerText = $params->get('footer_text', '');

$modParams = json_decode($params);
$modParams->header_text = '';
$modParams->footer_text = '';
$calendarParams = json_encode($modParams);
?>

<?php if ($headerText) : ?>
	<div class="ic-calendar-header">
		<?php echo $headerText; ?>
	</div>
<?php endif; ?>
<div id="icagenda_calendar_content"
	data-modid="<?php echo $this->module->id; ?>"
	data-calendar-params="<?php echo htmlspecialchars($calendarParams); ?>"
	>
	<?php echo IcagendaCalendarHelper::getCalendar($this->module->id, $calendarParams); ?>
</div>
<?php if ($footerText) : ?>
	<div class="ic-calendar-footer">
		<?php echo $footerText; ?>
	</div>
<?php endif; ?>
