<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-05-05
 *
 * @package     iCagenda.Admin
 * @subpackage  Layouts.icagenda
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.8.0
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

$version = $displayData['version'] ?? '';
?>

<div class="d-flex justify-content-between flex-column flex-sm-row flex-lg-column flex-xl-row align-items-center">
	<div class="me-2 align-self-center">
		<div class="mt-2 mb-0 text-nowrap">
			<img src="../media/com_icagenda/images/iCagenda-brand.svg" alt="JoomliC logo" border="0" width="auto" height="40" />
			<?php if ($version) : ?>
				<sup class="badge bg-info" style="font-size: 1em; font-weight:500; margin-left: .25em;">&nbsp;<?php echo strtoupper($version); ?>&nbsp;</sup>
			<?php endif; ?>
		</div>
		<div class="ms-5 h5">
			<?php echo Text::_('COM_ICAGENDA_COMPONENT_DESC') ?>
		</div>
	</div>
	<div class="ms-2 align-self-center">
		<img loading="eager" decoding="async" src="../media/com_icagenda/images/iCagenda-logo-brand.svg" alt="iCagenda logo" class="d-none d-xl-block w-75 h-auto float-end" width="120" height="120" />
		<img loading="eager" decoding="async" src="../media/com_icagenda/images/iCagenda-logo-brand.svg" alt="iCagenda logo" class="d-block d-xl-none" width="120" height="120" />
	</div>
</div>
