<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-06-11
 *
 * @package     iCagenda.Admin
 * @subpackage  Layouts.icagenda
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.8.0
 *----------------------------------------------------------------------------
*/

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

$author         = $displayData['author'] ?? '';
$authorEmail    = $displayData['authorEmail'] ?? '';
$authorUrl      = $displayData['authorUrl'] ?? '';
$authorWebsite  = $displayData['authorWebsite'] ?? '';
$description    = $displayData['description'] ?? '';
$name           = $displayData['name'] ?? '';
$pack           = $displayData['pack'] ?? '';
$updateDownload = $displayData['updateDownload'] ?? '';
$updateVersion  = $displayData['updateVersion'] ?? '';
$version        = $displayData['version'] ?? Text::_('COM_ICAGENDA_THEMES_VERSION_UNKNOWN');

$theme = [
	'name' => $name,
	'slug' => $pack,
];
?>

<div class="card mb-4">
	<div class="card-header text-center">
		<h3 class="h4 text-center">
			<?php echo $name; ?> <small class="text-muted">(<?php echo $pack; ?>)</small>
		</h3>
	</div>
	<div class="card-body">
		<div class="text-center mb-3">
			<?php echo HTMLHelper::_('themes.thumb', $theme); ?>
			<?php echo HTMLHelper::_('themes.thumbModal', $theme); ?>
		</div>
		<p>
			<?php echo $description; ?>
		</p>
		<p>
			<?php if ($author) : ?>
				<div>
					<?php if ($authorEmail) : ?>
						<?php echo Text::sprintf('COM_ICAGENDA_THEMES_AUTHOR', '<a href="mailto:' . $authorEmail . '"><strong>' . $author . '</strong></a>'); ?>
					<?php else : ?>
						<?php echo Text::sprintf('COM_ICAGENDA_THEMES_AUTHOR', '<strong>' . $author . '</strong>'); ?>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<?php if ($authorWebsite) : ?>
				<div>
					<?php if ($authorUrl) : ?>
						<?php echo Text::sprintf('COM_ICAGENDA_THEMES_AUTHOR_WEBSITE', '<a href="' . $authorUrl . '" target="_blank"><strong>' . $authorWebsite . '</strong></a>'); ?>
					<?php else : ?>
						<?php echo Text::sprintf('COM_ICAGENDA_THEMES_AUTHOR_WEBSITE', '<strong>' . $authorWebsite . '</strong>'); ?>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</p>
	</div>
</div>
