<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-10-30
 *
 * @package     iCagenda.Admin
 * @subpackage  src.Utilities.Update
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.7.18
 *----------------------------------------------------------------------------
*/

namespace iCutilities\Update;

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;

/**
 * class icagendaUpdate
 */
class icagendaUpdate
{
	/**
	 * iCagenda Update Check
	 */
	static public function checkUpdate()
	{
		$db       = Factory::getContainer()->get('DatabaseDriver');
		$document = Factory::getDocument();

		HTMLHelper::_('jquery.framework');
		HTMLHelper::_('script', 'com_icagenda/icagendaupdatecheck.js', ['version' => 'auto', 'relative' => true]);

		// Load Vector iCicons Font
		HTMLHelper::_('stylesheet', 'media/com_icagenda/icicons/style.css');

		$query = $db->createQuery()
			->select('extension_id')
			->from($db->qn('#__extensions'))
			->where($db->qn('element') . " = " . $db->q('pkg_icagenda'));
		$db->setQuery($query);
		$eid = $db->loadResult();

		if (empty($eid)) {
			return [];
		}

		$token    = Session::getFormToken() . '=' . 1;
		$url      = Uri::base() . 'index.php?option=com_installer&view=update&filter_search=EID:' . $eid . '&' . $token;
		$ajax_url = Uri::base() . 'index.php?option=com_installer&view=update&task=update.ajax&' . $token;

		$script   = [];
		$script[] = 'var icagendaupdate_eid = \'' . $eid . '\';';
		$script[] = 'var icagendaupdate_url = \'' . $url . '\';';
		$script[] = 'var icagendaupdate_ajax_url = \'' . $ajax_url . '\';';
		$script[] = 'var icagendaupdate_text = {'
					. '"UPTODATE" : "<div class=\"btn btn-sm text-success\"><span class=\"icon-ok\"></span>&nbsp;&nbsp;' . Text::_('ICAGENDA_LIVEUPDATE_UPTODATE', true) . '</div>",'
					. '"UPDATEFOUND": "<div class=\"btn btn-sm btn-danger\"><span class=\"icon-upload\"></span>&nbsp;&nbsp;<strong>' . Text::_('ICAGENDA_LIVEUPDATE_UPDATEFOUND', true) . '</strong></div>",'
					. '"UPDATEFOUND_MESSAGE": "' . Text::_('ICAGENDA_LIVEUPDATE_UPDATEFOUND_MESSAGE', true) . '",'
					. '"UPDATEFOUND_BUTTON": "' . Text::_('ICAGENDA_LIVEUPDATE_UPDATEFOUND_BUTTON', true) . '",'
					. '"ERROR": "' . Text::_('ICAGENDA_LIVEUPDATE_ERROR', true) . '",'
					. '};';

		$document->addScriptDeclaration(implode("\n", $script));

		return [
			'link'    => 'index.php?option=com_installer&view=update&filter_search=EID:' . $eid . '&' . $token,
			'image'   => 'iCicon-iclogo',
			'text'    => '<div class="btn btn-sm text-primary"><span class="icon-loop"></span>&nbsp;&nbsp;' . Text::_('ICAGENDA_LIVEUPDATE_CHECKING') . '</div>',
			'title'   => 'iCagenda Updater',
			'target'  => '',
			'onclick' => '',
			'id'      => 'icagendaupdate',
		];
	}
}
