<?php
/**
 *----------------------------------------------------------------------------
 * iC Library   Plugin System
 *----------------------------------------------------------------------------
 * @version     1.5.2 2022-04-12
 *
 * @package     iC Library
 * @subpackage  Plugin.System
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2013-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @since       1.0
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper as JComponentHelper;
use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\Form\FormHelper;

/**
 * iC Library plugin class.
 */
class plgSystemiC_library extends JPlugin
{
	/**
	 * Method to register iC library.
	 *
	 * return  void
	 */
	public function onAfterInitialise()
	{
		if (is_dir(JPATH_LIBRARIES . '/ic_library'))
		{
			// Ensure that autoloaders are set
			\JLoader::setup();

			// Set iC Library prefix
			\JLoader::registerPrefix('iC', JPATH_LIBRARIES . '/ic_library/lib');

			// Common fields
			if (version_compare(JVERSION, '4.0', 'lt'))
			{
				// Set iC Library namespace
				\JLoader::registerNamespace('iClib', JPATH_LIBRARIES . '/ic_library', false, false, 'psr4');

				JFormHelper::addFieldPath(JPATH_LIBRARIES . '/ic_library/lib/form/field');
				JFormHelper::addRulePath(JPATH_LIBRARIES . '/ic_library/lib/form/rule');
			}
			else
			{
				// Set iC Library namespace
				\JLoader::registerNamespace('iClib', JPATH_LIBRARIES . '/ic_library', false, false);

				// To be enabled for iCagenda 4 (with J4 support only)
				//FormHelper::addFieldPrefix('iClib\Form\Field');
				FormHelper::addRulePrefix('iClib\Form\Rule');
				FormHelper::addFieldPath(JPATH_LIBRARIES . '/ic_library/lib/form/field');
				FormHelper::addRulePath(JPATH_LIBRARIES . '/ic_library/lib/form/rule');
			}

			// Test if translation is missing, set to en-GB by default
			$language = JFactory::getLanguage();
			$language->load('lib_ic_library', JPATH_SITE, 'en-GB', true);
			$language->load('lib_ic_library', JPATH_SITE, null, true);
		}
	}
}
