<?php
/**
 *----------------------------------------------------------------------------
 * iC Library   Library by Jooml!C, for Joomla!
 *----------------------------------------------------------------------------
 * @version     2.1.0 2023-10-18
 *
 * @package     iC Library
 * @subpackage  Form.Field
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2013-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       1.4.0
 *----------------------------------------------------------------------------
*/

namespace iClib\Form\Field;

\defined('JPATH_PLATFORM') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Uri\Uri;

/**
 * Sortable fields form field
 * Note: Not yet use (will be for iCagenda J4 only)
 *
 * @see  iClib/lib/form/field  iCFormFieldSortableFields
 */
class SortableFieldsField extends FormField
{
	public $type = 'SortableFields';

	public function getLabel()
	{
		$app        = Factory::getApplication();
		$document   = Factory::getDocument();

		$isMenu     = ($app->input->get('option') == 'com_menus');
		$menuParams = $isMenu ? 'params_' : '';

		if (empty($this->element['label']) && empty($this->element['description']))
		{
			return '';
		}

		$title          = $this->element['label']
						? (string) $this->element['label']
						: ($this->element['title'] ? (string) $this->element['title'] : '');
		$heading        = $this->element['heading'] ? (string) $this->element['heading'] : 'h4';
		$description    = (string) $this->element['infotext'];
		$class          = ! empty($this->class)
						? ' class="' . $this->class . '"'
						: ' class="alert alert-info input-xxlarge" style="display:block;clear:both;"';
		$close          = (string) $this->element['close'];

		$html = array();

		if ($close)
		{
			$close = $close == 'true' ? 'alert' : $close;
			$html[] = '<button type="button" class="close" data-dismiss="' . $close . '">&times;</button>';
		}

		$html[] = '<div class="ic-clearfix"></div>';
		$html[] = '<div' . $class . '>';
//		$html[] = !empty($title) ? '<' . $heading . '>' . Text::_($title) . '</' . $heading . '>' : '';
		$html[] = ! empty($description) ? Text::_($description) : '';
		$html[] = '</div>';

		$html[] = '<div id="ic-sortable" class="span6" style="margin-bottom: 24px">';

		$fieldnames = isset($this->value) ? $this->value : (string) $this->element['default'];
		$fieldnames = explode(',', $fieldnames);

		$group = $isMenu ? 'params' : '';

		foreach ($fieldnames AS $k => $fieldname)
		{
			$fieldname = trim($fieldname);
			$field     = $this->form->getField($fieldname, $group);

			// Make sure the selected field is hidden
			if ( ! isset($field->element['type']) || $field->element['type'] !== 'hidden')
			{
				$this->form->setFieldAttribute($fieldname, 'type', 'hidden');
			}

			// Settings attributes
			$name = isset($field->element['name']) ? $field->element['name'] : false;

			if ($name)
			{
				$rendertype  = isset($field->element['rendertype'])  ? $field->element['rendertype']  : 'text';
				$label       = isset($field->element['label'])       ? $field->element['label']       : '';
				$description = isset($field->element['description']) ? $field->element['description'] : '';
				$class       = isset($field->element['class'])       ? $field->element['class']       : '';
				$labelclass  = isset($field->element['labelclass'])  ? $field->element['labelclass']  : '';
				$default     = isset($field->element['default'])     ? $field->element['default']     : '';

				// Add new field to the sortable list
				$type_field = new \SimpleXMLElement('<field />');
				$type_field->addAttribute('name', $fieldname);
				$type_field->addAttribute('type', $rendertype);
				$type_field->addAttribute('label', $label);
				$type_field->addAttribute('description', $description);
				$type_field->addAttribute('class', $class);
				$type_field->addAttribute('labelclass', $labelclass);
				$type_field->addAttribute('default', $default);
//				$type_field->addAttribute('fieldset', 'list');

				if (isset($field->element->option))
				{
					$values = (array) $field->element->xpath('option');
					$options = (array) $field->element->option;
					unset($values['@attributes']);
					unset($options['@attributes']);


					// Add 'Use Global' with value
					if ($field->element['useglobal'])
					{
						$tmp        = new \stdClass;
						$tmp->value = '';
						$tmp->text  = Text::_('JGLOBAL_USE_GLOBAL');
						$component  = $app->input->getCmd('option');

						// Get correct component for menu items
						if ($component == 'com_menus')
						{
							$link      = $this->form->getData()->get('link');
							$uri       = new Uri($link);
							$component = $uri->getVar('option', 'com_menus');
						}

						$params = ComponentHelper::getParams($component);
						$value  = $params->get($fieldname);

						// Try with global configuration
						if (is_null($value))
						{
							$value = Factory::getConfig()->get($fieldname);
						}

						// Try with menu configuration
						if (is_null($value) && $app->input->getCmd('option') == 'com_menus')
						{
							$value = ComponentHelper::getParams('com_menus')->get($fieldname);
						}

						if (!is_null($value))
						{
							$value = (string) $value;

							foreach ($values as $key => $option)
							{
								if ((string) $values[$key]['value'] === $value)
								{
									$value = Text::_($option);

									break;
								}
							}

							$tmp->text  = Text::sprintf('JGLOBAL_USE_GLOBAL_VALUE', $value);
						}

						$child = $type_field->addChild('option', $tmp->text);
						$child->addAttribute('value', $tmp->value);
					}


					// Add Options
					foreach ($values as $key => $option)
					{
						$child = $type_field->addChild('option', $option);
						$child->addAttribute('value', $values[$key]['value']);
					}
				}

				$this->form->setField($type_field, $group);

				$label = $this->form->getLabel($fieldname, $group);
				$input = $this->form->getInput($fieldname, $group);

				$html[] = '<div id="' . $fieldname . '" class="ui-state-default">';

				$html[] = '<span class="icon-move" style="line-height: 36px; float: left"> </span>';
				$html[] = LayoutHelper::render('joomla.form.renderfield',
							array('input' => $input, 'label' => $label,'name' => 'test', 'options' => array()));
				$html[] = '</div>';

				$label_suffix = '';

				if ($fieldname == 'filter_search')
				{
					$label_suffix = Text::_('IC_FIELD_TYPE_TEXT');
				}
				elseif (in_array($fieldname, array('filter_from', 'filter_to')))
				{
					$label_suffix = Text::_('IC_FIELD_TYPE_CALENDAR');
				}
				elseif (in_array($fieldname, array('filter_category', 'filter_month', 'filter_year')))
				{
					$label_suffix = Text::_('IC_FIELD_TYPE_LIST');
				}

				$document->addScriptDeclaration('
					jQuery(document).ready(function($) {
						var label = $("#jform_' . $menuParams . $fieldname . '-lbl").text();
						$("#jform_' . $menuParams . $fieldname . '-lbl").html("<strong>"+label+"</strong> <small>(' . $label_suffix . ')</small>");
					});
				');
			}
		}

		$html[] = '</div>';

		$document->addScriptDeclaration('
			jQuery(document).ready(function($) {
				$( "#ic-sortable" ).sortable({
					placeholder: "ui-state-highlight",
					cursor: "crosshair",
					update: function(event, ui) {
						var order = $("#ic-sortable").sortable("toArray");
						$("#' . $this->id . '").val(order.join(","));
					}
				});
				$( "#ic-sortable" ).disableSelection();

				// Will hide control-group field, if input type is hidden
//				$("input[type=hidden]").parents(".control-group").css("margin-bottom", "0");
			});
		');

		$document->addStyleDeclaration('
			.ui-state-default {
				background: rgba(155,155,155,0.05);
				border: 1px solid rgba(155,155,155,0.5);
				padding: 3px 5px;
				margin-bottom: 3px;
			}
			.ui-sortable-helper{
				/*
				background: #449d44;
				background: rgba(68, 157, 68, 0.5);
				*/
				/* @brand-info BT3 */
				background; #5bc0de;
				background: rgba(91, 192, 222, 0.5);

				border: none;
				color: #fff;
				padding: 3px 5px;
				margin-bottom: 3px;
			}
			.ui-state-default .control-group {
				margin-bottom: 5px;
			}
			.icon-move:hover,
			.ui-state-default:hover {
				cursor: move;
			}
			.ui-state-highlight {
				/*
				background: #449d44;
				background: rgba(68, 157, 68, 0.7);
				border: 1px dotted #398439;
				*/
				/* @brand-info BT3 */
				background; #5bc0de;
				background: rgba(91, 192, 222, 0.5);
				border: 1px dotted #2aa8ce;

				height: 44px;
				margin-bottom: 3px;
			}
		');

//		HTMLHelper::_('jquery.framework');

		HTMLHelper::_('stylesheet', 'com_icagenda/jquery-ui-1.8.17.custom.css', array('relative' => true, 'version' => 'auto'));

		$document->addScript('https://code.jquery.com/jquery-1.12.4.min.js');
		$document->addScript('//code.jquery.com/ui/1.11.4/jquery-ui.js');

		return '</div><div>' . implode('', $html);
	}

	public function getInput()
	{
		return '<input type="hidden" id="' . $this->id . '" name="' . $this->name . '" value="' . $this->value . '" />';
	}
}
