<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.5.4 2015-04-13
 *
 * @package     iCagenda.Admin
 * @subpackage  Assets.Elements
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.5.4
 *----------------------------------------------------------------------------
*/

// No direct access to this file
defined('JPATH_BASE') or die;

jimport('joomla.form.formfield');


class JFormFieldTitleHeader extends JFormField
{
	protected $type = 'TitleHeader';

	protected function getInput()
	{
		return ' ';
	}

	protected function getLabel()
	{
    	$label = $this->element['label'];
		$label = $this->translateLabel ? JText::_($label) : $label;

    	$html = '<h3>' . $label . '</h3>';

    	return $html;
	}
}
