<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.8.0 2021-09-27
 *
 * @package     iCagenda.Admin
 * @subpackage  Assets.Elements
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       1.2.3
 *----------------------------------------------------------------------------
*/

// No direct access to this file
defined('JPATH_BASE') or die;

jimport('joomla.form.formfield');

// Test if translation is missing, set to en-GB by default
$language = JFactory::getLanguage();
$language->load('com_icagenda', JPATH_ADMINISTRATOR, 'en-GB', true);
$language->load('com_icagenda', JPATH_ADMINISTRATOR, null, true);

JHtml::_('stylesheet', 'com_icagenda/icagenda-back.css', array('relative' => true, 'version' => 'auto'));


class JFormFieldTitleImg extends JFormField
{
	protected $type = 'TitleImg';

	protected function getLabel()
	{
		return ' ';
	}

	protected function getInput()
	{
		$html = array();

		// Affichage texte

		$label = $this->element['label'];
		$label = $this->translateLabel ? JText::_($label) : $label;

		$style = $this->element['style'];
		$style = $this->translateLabel ? JText::_($style) : $style;

		$class = $this->element['class'];
		$class = $this->translateLabel ? JText::_($class) : $class;

		$icimage = $this->element['icimage'];
		$image = '../media/com_icagenda/images/'. $icimage .'';

		$icicon = $this->element['icicon'];

		// Contruction
		$html[] = '<div class="';
		$html[] = $class;
		$html[] = ' element-title-img" ';
		$html[] = 'style="';
		$html[] = $style;
		$html[] = '">';

		if ($icimage)
		{
			$html[] = '<img src="';
			$html[] = $image;
			$html[] = '" />';
		}
		elseif ($icicon)
		{
			$html[] = '<span class="iCicon-';
			$html[] = $icicon;
			$html[] = '"></span> ';
		}

		$html[] = $label;
		$html[] = '</div>';

		return implode('',$html);
	}
}
