<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.8.0 2019-07-31
 *
 * @package     iCagenda.Admin
 * @subpackage  Utilities
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.8.0
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

jimport('joomla.form.formfield');

// Test if translation is missing, set to en-GB by default
$language = JFactory::getLanguage();
$language->load('com_icagenda', JPATH_ADMINISTRATOR, 'en-GB', true);
$language->load('com_icagenda', JPATH_ADMINISTRATOR, null, true);

JHtml::stylesheet('com_icagenda/icagenda-back.css', false, true);


class JFormFieldConfig_emailtags extends JFormField
{
	protected $type = 'config_emailtags';

	protected function getLabel()
	{
		return ' ';
	}

	protected function getInput()
	{
		$html = array();

		$class  = $this->element['class'];
		$style  = $this->element['style'];
		$icicon = $this->element['icicon'];

		$html[] = '<div class="' . $class . ' element-title-img"';
		$html[] = ' style="' . $style . '">';
		$html[] = '<span class="iCicon-' . $icicon . '"></span> ';

		$html[] = JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_LABEL') . '<br /><br />';

		$html[] = '<table><tr>';
		$html[] = '<td><strong>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_USER_LABEL') . '</strong></td>';
		$html[] = '<td width="30"></td>';
		$html[] = '<td><strong>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_SITE_LABEL') . '</strong></td>';
		$html[] = '<td width="30"></td>';
		$html[] = '<td><strong>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_LABEL') . '</strong></td>';
		$html[] = '</tr>';
		$html[] = '<tr>';
		$html[] = '<td valign="top">';
		$html[] = '<ul>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_USER_NAME') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_USER_EMAIL') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_USER_PHONE') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_USER_TICKETS') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_USER_CUSTOMFIELDS') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_USER_NOTES') . '</li>';
		$html[] = '</ul>';
		$html[] = '</td>';
		$html[] = '<td width="30"></td>';
		$html[] = '<td valign="top">';
		$html[] = '<ul>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_SITE_SITENAME') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_SITE_SITEURL') . '</li>';
		$html[] = '</ul>';
		$html[] = '</td>';
		$html[] = '<td width="30"></td>';
		$html[] = '<td valign="top">';
		$html[] = '<ul>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_TITLE') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_EVENTURL') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_AUTHOR') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_AUTHOREMAIL') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_CONTACTEMAIL') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_DATETIME') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_DATE') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_TIME') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_STARTDATE') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_ENDDATE') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_STARTDATETIME') . '</li>';
		$html[] = '<li>' . JText::_('COM_ICAGENDA_EMAIL_TAGS_NOTICE_EVENT_ENDDATETIME') . '</li>';
		$html[] = '</ul>';
		$html[] = '</td>';
		$html[] = '</tr>';
		$html[] = '</table><br />';
		
		$html[] = '</div>';

		return implode('',$html);
	}
}
