<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.8.0 2021-09-27
 *
 * @package     iCagenda.Site
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.3.7
 *----------------------------------------------------------------------------
*/

// No direct access to this file
defined('_JEXEC') or die();

jimport( 'joomla.filesystem.path' );
jimport('joomla.form.formfield');

class JFormFieldModal_iC_editor extends JFormField
{
	/**
	 * The form field type.
	 */
	protected $type = 'modal_iC_editor';

	/**
	 * Method to get the field input markup.
	 */
	protected function getInput()
	{
		$icBody = $this->value;

		if (strpos($icBody,'\n') !== false)
		{
			$array_newline = array('\\n', '\n');
			$icBody = str_replace($array_newline, '<br />', $icBody);
		}

		if (version_compare(JVERSION, '4.0', 'lt'))
		{
			$editor = JFactory::getEditor();
		}
		else
		{
			$editor = JEditor::getInstance();
		}

		$html	= array();

		$html[] = '<div id="'.$this->name.'_ic_editor"><fieldset class="span9 iCleft">';
		$html[] = $editor->display($this->name, $icBody, "100%", "300", "300", "20", 1, null, null, null, array('mode' => 'advanced'));
		$html[] = '</fieldset></div>';

		return implode("\n", $html);
	}
}
