<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.8.0 2022-02-03
 *
 * @package     iCagenda.Admin
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.2.0
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

jimport( 'joomla.filesystem.path' );
jimport('joomla.form.formfield');

class JFormFieldModal_multicat extends JFormField
{
	protected $type = 'modal_multicat';

	protected function getInput()
	{
		// Initialize some field attributes.
		$class = ! empty($this->class) ? ' class="' . $this->class . '"' : '';

		// Query List of Categories
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select('a.title, a.state, a.id')
			->from('#__icagenda_category AS a');

		$db->setQuery($query);

		$cat = $db->loadObjectList();

		if ( ! is_array($this->value))
		{
			if ( ! $this->value) $this->value = "0";
			$this->value = array($this->value);
		}

		$html = ' <select multiple id="' . $this->id . '_id" name="' . $this->name . '"' . $class . '>';

//		$html.= '<option value="0" disabled="disabled"';

//		if (in_array('0', $this->value))
//		{
//			$html.= ' selected="selected"';
//		}

//		$html.= '>' . JTEXT::_('COM_ICAGENDA_ALL_CATEGORIES') . '</option>';

		foreach ($cat as $c)
		{
			if ($c->state == '1')
			{
				$html.= '<option value="' . $c->id . '"';

				if (in_array($c->id, $this->value) && ! in_array('0', $this->value))
				{
					$html.= ' selected="selected"';
				}

				$html.= '>' . $c->title . '</option>';
			}
		}

		$html.= '</select>';

		return $html;
	}
}
