<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.6.0 2016-07-07
 *
 * @package     iCagenda.Admin
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.6.0
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

/**
 * Spacer Description form field
 */
class JFormFieldSpacer_Description extends JFormField
{
	public $type = 'spacer_description';

	public function getLabel()
	{
		if (empty($this->element['label']))
		{
			return '';
		}

		$desc   = $this->element['label']
				? (string) $this->element['label']
				: ($this->element['title'] ? (string) $this->element['title'] : '');

		$class  = $this->class ? (string) trim($this->class) : '';
		$class  = ! empty($class) ? ' class="' . $class . '"' : ' style="clear: both;"';

		$html   = array();

		$html[] = '<div' . $class . '>';
		$html[] = ! empty($desc) ? $desc : '';
		$html[] = '</div>';

		return '</div><div>' . implode('', $html);
	}

	public function getInput()
	{
		return '';
	}
}
