<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.8.0 2021-09-08
 *
 * @package     iCagenda.Admin
 * @subpackage  src.Controller
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.4.0
 *----------------------------------------------------------------------------
*/

namespace WebiC\Component\iCagenda\Administrator\Controller;

\defined('_JEXEC') or die;

use iCutilities\Ajax\Filter as icagendaAjaxFilter;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\FormController;

/**
 * iCagenda Component Custom Field Controller
 */
class CustomfieldController extends FormController
{
	/**
	 * Return Ajax to check if a custom field group is set to any custom field
	 *
	 * @since   3.6.0
	 */
	function checkGroup()
	{
		icagendaAjaxFilter::checkCustomFieldGroup();
	}

	/**
	 * Return Ajax to delete a custom field group
	 *
	 * @since   3.6.0
	 */
	function deleteGroup()
	{
		icagendaAjaxFilter::deleteCustomFieldGroup();
	}

	/**
	 * Return Ajax to save a new custom field group
	 *
	 * @since   3.6.0
	 */
	function newGroup()
	{
		icagendaAjaxFilter::saveCustomFieldGroup();
	}

	/**
	 * Return Ajax to save a new custom field group
	 *
	 * @since   3.8.0
	 */
	function updateGroups()
	{
		icagendaAjaxFilter::getOptionsCustomfieldGroups();
	}
}
