<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.8.0 2021-09-27
 *
 * @package     iCagenda.Admin
 * @subpackage  src.Controller
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.3.3
 *----------------------------------------------------------------------------
*/

namespace WebiC\Component\iCagenda\Administrator\Controller;

\defined('_JEXEC') or die;

use iCutilities\Ajax\Ajax as icagendaAjax;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\FormController;

/**
 * iCagenda Component Registration Controller
 */
class RegistrationController extends FormController
{
	/**
	 * Return Ajax to load date select options
	 *
	 * @since   3.5.9
	 */
	function dates()
	{
		icagendaAjax::getOptionsEventDates('registration');
	}

	/**
	 * Return Full name/Username using Ajax (depending on Global Options)
	 *
	 * @since   3.6.0
	 */
	function registrationName()
	{
		$userId = Factory::getApplication()->input->get('userid', '');

		icagendaAjax::getRegistrationName($userId);
	}
}
