<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.8.19 2023-10-09
 *
 * @package     iCagenda.Admin
 * @subpackage  src.Utilities.Thumb
 * @link        https://www.icagenda.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2023 Cyril Rezé / iCagenda. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.4
 *----------------------------------------------------------------------------
*/

namespace iCutilities\Thumb;

\defined('_JEXEC') or die;

use iClib\Thumb\Get as iCThumbGet;
use iCutilities\Media\Media as icagendaMedia;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Filesystem\Folder;

/**
 * class icagendaThumb
 */
class Thumb
{
	/**
	 * Return the LARGE thumbnail from an image
	 * Generated by iCagenda with Global Options settings
	 */
	static public function sizeLarge($image, $type = null, $checksize = null)
	{
		$thumbsPath = icagendaMedia::iCagendaThumbsPath();

		$default = ['900','600','100', '0'];

		// Options Small Size
		$thumbOptions = ComponentHelper::getParams('com_icagenda')->get('thumb_large', []);

		$options = self::getThumbOptions($thumbOptions, $default);

		// Generate large thumb if not exist
		$sizeLarge = iCThumbGet::thumbnail($image, $thumbsPath, 'themes', $options[0], $options[1], $options[2], $options[3], 'ic_large', $type, $checksize);

		return $sizeLarge;
	}

	/**
	 * Return the MEDIUM thumbnail from an image
	 * Generated by iCagenda with Global Options settings
	 */
	static public function sizeMedium($image, $type = null, $checksize = null)
	{
		$thumbsPath = icagendaMedia::iCagendaThumbsPath();

		$default = ['300','300','100', '0'];

		// Options Small Size
		$thumbOptions = ComponentHelper::getParams('com_icagenda')->get('thumb_medium', []);

		$options = self::getThumbOptions($thumbOptions, $default);

		// Generate medium thumb if not exist
		$sizeMedium = iCThumbGet::thumbnail($image, $thumbsPath, 'themes', $options[0], $options[1], $options[2], $options[3], 'ic_medium', $type, $checksize);

		return $sizeMedium;
	}

	/**
	 * Return the SMALL thumbnail from an image
	 * Generated by iCagenda with Global Options settings
	 */
	static public function sizeSmall($image, $type = null, $checksize = null)
	{
		$thumbsPath = icagendaMedia::iCagendaThumbsPath();

		$default = ['100','100','100', '0'];

		// Options Small Size
		$thumbOptions = ComponentHelper::getParams('com_icagenda')->get('thumb_small', []);

		$options = self::getThumbOptions($thumbOptions, $default);

		// Generate small thumb if not exist
		$sizeSmall = iCThumbGet::thumbnail($image, $thumbsPath, 'themes', $options[0], $options[1], $options[2], $options[3], 'ic_small', $type, $checksize);

		return $sizeSmall;
	}

	/**
	 * Return the SMALL thumbnail from an image
	 * Generated by iCagenda with Global Options settings
	 */
	static public function sizeXSmall($image, $type = null, $checksize = null)
	{
		$thumbsPath = icagendaMedia::iCagendaThumbsPath();

		$default = ['48','48','100', '1'];

		// Options Small Size
		$thumbOptions = ComponentHelper::getParams('com_icagenda')->get('thumb_xsmall', []);

		$options = self::getThumbOptions($thumbOptions, $default);

		// Generate xsmall thumb if not exist
		$sizeXSmall = iCThumbGet::thumbnail($image, $thumbsPath, 'themes', $options[0], $options[1], $options[2], $options[3], 'ic_xsmall', $type, $checksize);

		return $sizeXSmall;
	}

	/**
	 * Return the iCagenda images path
	 * 
	 * @Deprecated 3.8.19 - Use icagendaMedia::iCagendaThumbsPath()
	 */
	static public function iCagendaImagesPath()
	{
		Log::add('icagendaThumb::iCagendaImagesPath() is deprecated. Use icagendaMedia::iCagendaThumbsPath() instead.', Log::WARNING, 'deprecated');

		return icagendaMedia::iCagendaThumbsPath();
	}

	/**
	 * Return the iCagenda images path
	 * 
	 * @since  3.8.9
	 */
	static public function getThumbOptions($settings, $default)
	{
		$width   = (isset($settings[0]) && is_numeric($settings[0])) ? (int) $settings[0] : $default[0];
		$height  = (isset($settings[1]) && is_numeric($settings[1])) ? (int) $settings[1] : $default[1];
		$quality = (isset($settings[2]) && is_numeric($settings[2])) ? (int) $settings[2] : $default[2];
		$crop    = isset($settings[3]) ? !empty($settings[3]) : !empty($default[3]);

		return [$width, $height, $quality, $crop];
	}

	/**
	 * Return the SMALL thumbnail from an image
	 * Generated by iCagenda with Global Options settings
	 * 
	 * @since  3.8.0
	 */
	static public function sizeOriginal($image)
	{
		if (version_compare(JVERSION, '4.0', 'lt'))
		{
			$img_url = $image;
		}
		else
		{
			$img = HTMLHelper::cleanImageURL($image);

			$img_url = $img->url;
		}

		return $img_url;
	}
}
